/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Constants;
import hipparcos.tools.NoMoreStars;
import hipparcos.tools.Star;
import hipparcos.tools.StarFactory;
import hipparcos.tools.StarStore;

public class StarLoader
implements Runnable {
    private Thread loader = null;
    private StarStore sky;
    private StarFactory fac;

    protected void init(StarStore sky, double deltaTol, boolean hipOnly) {
        if (Constants.verbose > 2) {
            System.out.println("Store - hipOnly:" + hipOnly);
        }
        this.sky = sky;
        this.fac = new StarFactory(sky.getAlpha(), sky.getDelta(), sky.getTol() + deltaTol, 99.0, hipOnly);
        this.loader = new Thread(this);
        this.loader.start();
    }

    public StarLoader(StarStore sky) {
        this.init(sky, 0.0, false);
    }

    public StarLoader(StarStore sky, double deltaTol, boolean hipOnly) {
        this.init(sky, deltaTol, hipOnly);
    }

    @Override
    public void run() {
        System.out.println("Starting StarLoader V3...");
        this.load();
        this.loader.stop();
        this.loader = null;
    }

    public boolean load() {
        boolean more = true;
        while (more) {
            try {
                Star star = this.fac.getNext();
                this.sky.addStar(star);
            }
            catch (NoMoreStars nms) {
                more = false;
            }
        }
        return true;
    }
}

