/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.Constants;
import hipparcos.tools.HIPproperties;
import hipparcos.tools.StarFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;

public class StarFactory3d
extends StarFactory {
    protected double x;
    protected double y;
    protected double z;
    protected double rad;

    public StarFactory3d(double x, double y, double z, double rad) {
        super(99.0, true);
        this.x = x;
        this.y = y;
        this.z = z;
        this.rad = rad;
        this.catprogs[0] = "shipmainxyz";
        this.catprogs[1] = null;
    }

    public StarFactory3d(double x, double y, double z, double rad, double vlim) {
        super(vlim, true);
        this.x = x;
        this.y = y;
        this.z = z;
        this.rad = rad;
        this.catprogs[0] = "shipmainxyz";
        this.catprogs[1] = null;
    }

    @Override
    protected boolean loadFromURL() {
        try {
            String theUrl = HIPproperties.getProperty("hipurl");
            if (Constants.verbose > 2) {
                System.out.println("Got property hipurl" + theUrl + ".");
            }
            theUrl = theUrl + "?noLinks=1&X=";
            theUrl = theUrl + new Integer((int)this.x).toString();
            theUrl = theUrl + "&Y=";
            theUrl = theUrl + new Integer((int)this.y).toString();
            theUrl = theUrl + "&Z=";
            theUrl = theUrl + new Integer((int)this.z).toString();
            theUrl = theUrl + "&radius=";
            theUrl = theUrl + new Integer((int)this.rad).toString();
            theUrl = theUrl + "&threshold=";
            theUrl = theUrl + new Double(this.vlim).toString();
            URL url = new URL(theUrl);
            InputStreamReader istream = new InputStreamReader(url.openStream());
            this.dstream = new BufferedReader(istream);
            if (Constants.verbose > 1) {
                System.out.println("opened " + theUrl + ".");
            }
        }
        catch (Exception e) {
            System.err.println("loadFromURL3d: " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected boolean loadFromDisk(String catprog) {
        try {
            String bins = HIPproperties.getProperty("bins");
            String cmd = bins + "/" + catprog + " -tq ";
            cmd = cmd + new Integer((int)this.x).toString() + " ";
            cmd = cmd + new Integer((int)this.y).toString() + " ";
            cmd = cmd + new Integer((int)this.z).toString() + " ";
            cmd = cmd + new Integer((int)this.rad).toString() + " ";
            cmd = cmd + new Double(this.vlim).toString() + " ";
            if (Constants.verbose > 1) {
                System.out.println("Running " + cmd + ".");
            }
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);
            InputStreamReader istream = new InputStreamReader(p.getInputStream());
            this.dstream = new BufferedReader(istream);
            return true;
        }
        catch (Exception e) {
            System.err.println("Some problem starting cat progs");
            e.printStackTrace();
            return false;
        }
    }
}

