/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.tools;

import hipparcos.tools.DelimitedLine;
import hipparcos.tools.HIPproperties;
import java.net.URL;
import java.text.DecimalFormat;

public class Star {
    public static DecimalFormat lform = new DecimalFormat("000.#########");
    public static DecimalFormat decform = new DecimalFormat(" 00.#########;-00.########");
    public static DecimalFormat sform = new DecimalFormat("00.###;-0.###");
    public static DecimalFormat mform = new DecimalFormat(" 000.###;-000.###");
    public String type;
    public String id;
    public double mag;
    public double alpha;
    public double delta;
    public double paralax;
    public double muAlpha;
    public double muDelta;
    public double b_v;
    public boolean inHIPnTYC = false;
    public boolean inHIP = false;

    public Star() {
        this.id = null;
    }

    public Star(Star copy) {
        this.type = copy.type;
        this.id = copy.id;
        this.mag = copy.mag;
        this.alpha = copy.alpha;
        this.delta = copy.delta;
        this.paralax = copy.paralax;
        this.muAlpha = copy.muAlpha;
        this.muDelta = copy.muDelta;
        this.inHIPnTYC = copy.inHIPnTYC;
        this.inHIP = copy.inHIP;
        this.b_v = copy.b_v;
    }

    public Star(String str) throws Exception {
        DelimitedLine line = new DelimitedLine(str, '|');
        this.type = line.getNextString();
        this.id = line.getNextString();
        String skip = line.getNextString();
        skip = line.getNextString();
        skip = line.getNextString();
        this.mag = line.getNextDouble();
        skip = line.getNextString();
        skip = line.getNextString();
        this.alpha = line.getNextDouble();
        this.delta = line.getNextDouble();
        skip = line.getNextString();
        this.paralax = line.getNextDouble();
        try {
            this.muAlpha = line.getNextDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.muDelta = line.getNextDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i = 13;
        if (this.type.startsWith("T")) {
            try {
                for (i = 13; i < 30; ++i) {
                    try {
                        skip = line.getNextString();
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Skip Failed " + e);
                    }
                }
                ++i;
                String tmpStr = line.getNextString();
                int tmp = new Integer(tmpStr);
                this.inHIPnTYC = tmp >= 1;
            }
            catch (Exception e) {
                this.inHIPnTYC = false;
            }
        } else {
            this.inHIP = true;
        }
        while (i < 36) {
            try {
                skip = line.getNextString();
                ++i;
            }
            catch (Exception e) {
                System.out.println("Skip Failed " + e);
            }
        }
        this.b_v = line.getNextDouble();
    }

    public String shortInfo() {
        String ret = null;
        ret = this.type.startsWith("T") ? new String("TYC" + this.id) : new String("HIP" + this.id);
        ret = ret + " V=";
        ret = ret + this.mag;
        return ret;
    }

    public static String header() {
        return "HIP/TYC        |Vmag |alpha       |delta    |parallax|mu_alpha|mu_delta|B-V";
    }

    public String toString() {
        String ret = null;
        ret = this.type.startsWith("T") ? new String("TYC" + this.id) : new String("HIP" + this.id);
        ret = this.buf(ret, 15);
        ret = ret + "|";
        ret = ret + this.buf(sform.format(this.mag), 5);
        ret = ret + "|";
        ret = ret + this.buf(lform.format(this.alpha), 12);
        ret = ret + "|";
        ret = ret + this.buf(decform.format(this.delta), 12);
        ret = ret + "|";
        ret = ret + this.buf(mform.format(this.paralax), 7);
        ret = ret + "|";
        ret = ret + this.buf(mform.format(this.muAlpha), 7);
        ret = ret + "|";
        ret = ret + this.buf(mform.format(this.muDelta), 7);
        ret = ret + "|";
        ret = ret + sform.format(this.b_v);
        return ret;
    }

    public String buf(String in, int len) {
        String ret = in;
        while (ret.length() < len) {
            ret = ret + " ";
        }
        return ret;
    }

    public double getMag() {
        return this.mag;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getParalax() {
        return this.paralax;
    }

    public double getMuAlpha() {
        return this.muAlpha;
    }

    public double getMuDelta() {
        return this.muDelta;
    }

    public double getB_V() {
        return this.b_v;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public boolean inHIP() {
        return this.inHIP;
    }

    public URL makeUrl() {
        String theUrl = HIPproperties.getProperty("hipurl") + "?";
        try {
            if (this.getType().startsWith("T")) {
                DelimitedLine tycnos = new DelimitedLine(this.id, ' ');
                theUrl = theUrl + "tyc1=" + tycnos.getNextInt();
                theUrl = theUrl + "&tyc2=" + tycnos.getNextInt();
                theUrl = theUrl + "&tyc3=" + tycnos.getNextInt();
            } else {
                theUrl = theUrl + "hipId=" + this.getId();
            }
            URL url = new URL(theUrl);
            return url;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public double getMuAlpha(int years) {
        return (double)years * (this.muAlpha / 3600000.0);
    }

    public double getMuDelta(int years) {
        return (double)years * (this.muDelta / 3600000.0);
    }
}

