/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import com.sun.j3d.utils.geometry.Sphere;
import hipparcos.tools.Constants;
import hipparcos.tools.Star;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;

public class Star3D
extends Sphere {
    public static final int flags = 33;
    protected Star star;
    protected static float colStep = 0.0f;
    protected static Appearance[] appearances;

    static void init() {
        appearances = new Appearance[Constants.colours.length];
        for (int i = 0; i < appearances.length; ++i) {
            Star3D.appearances[i] = new Appearance();
            float r = Constants.colours[i][0];
            float b = Constants.colours[i][1];
            float g = Constants.colours[i][2];
            if (Constants.verbose > 3) {
                System.out.println("Col:" + i + "r:" + r + " b:" + b + " g:" + g);
            }
            Material material = new Material();
            material.setDiffuseColor(r + 0.05f, g + 0.05f, b + 0.05f);
            material.setShininess(10.0f);
            material.setAmbientColor(r, g, b);
            material.setLightingEnable(true);
            appearances[i].setMaterial(material);
        }
    }

    public static Appearance sgetAppearance(int col) {
        if (appearances == null) {
            Star3D.init();
        }
        return appearances[col];
    }

    public static Appearance getAppearance(Star star) {
        int col;
        if (appearances == null) {
            Star3D.init();
        }
        double b_v = star.getB_V();
        for (col = 0; col < Constants.colBands.length && b_v > (double)Constants.colBands[col]; ++col) {
        }
        if (col > Constants.colBands.length) {
            col = Constants.colBands.length;
        }
        if (Constants.verbose > 3) {
            System.out.println("Allocating colour " + col + " for " + b_v + " " + star.getId());
        }
        return appearances[col];
    }

    public static float calcSize(Star star) {
        float size = (float)(star.getMag() + 5.0 + 5.0 * Math.log(star.getParalax()));
        size = (60.0f - size) / 60.0f;
        return size;
    }

    public Star3D(Star star) {
        super(Star3D.calcSize(star), 33, 15, Star3D.getAppearance(star));
        this.star = star;
    }

    public Star getStar() {
        return this.star;
    }

    public String toString() {
        return this.star.toString();
    }
}

