/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky3d;

import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import hipparcos.sky3d.ClickBehaviour;
import hipparcos.sky3d.GroupIter;
import hipparcos.sky3d.RotateAble;
import hipparcos.sky3d.Star3D;
import hipparcos.sky3d.StarPanel;
import hipparcos.tools.Constants;
import hipparcos.tools.Star;
import hipparcos.tools.StarStore;
import java.util.Iterator;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Sky3D
extends Canvas3D
implements RotateAble,
StarStore {
    private TransformGroup objTrans;
    private TransformGroup objScale;
    private BranchGroup scene;
    private SimpleUniverse uni = null;
    private Vector3d center;
    protected ClickBehaviour clicker;
    protected StarPanel starPanel;
    protected MouseZoom zoom;
    protected RotationInterpolator rotator;
    protected double alpha;
    protected double delta;
    protected double tol;
    protected double tolsquared;

    @Override
    public Iterator getStars() {
        return new GroupIter(this.objTrans.getAllChildren());
    }

    @Override
    public RotationInterpolator getRotationInterpolator() {
        return this.rotator;
    }

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        this.objScale = new TransformGroup();
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        this.objTrans.setCapability(12);
        this.objScale.addChild((Node)this.objTrans);
        objRoot.addChild((Node)this.objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 120.0);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
        Background bgNode = new Background(bgColor);
        bgNode.setApplicationBounds((Bounds)bounds);
        objRoot.addChild((Node)bgNode);
        AmbientLight ambientLightNode = new AmbientLight();
        ambientLightNode.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)ambientLightNode);
        Color3f light1Color = new Color3f(0.8f, 0.8f, 0.8f);
        Vector3f light1Direction = new Vector3f(4.0f, -7.0f, -12.0f);
        Color3f light2Color = new Color3f(0.3f, 0.3f, 0.3f);
        Vector3f light2Direction = new Vector3f(-6.0f, -2.0f, -1.0f);
        DirectionalLight light1 = new DirectionalLight(light1Color, light1Direction);
        light1.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light1);
        DirectionalLight light2 = new DirectionalLight(light2Color, light2Direction);
        light2.setInfluencingBounds((Bounds)bounds);
        objRoot.addChild((Node)light2);
        MouseRotate behavior = new MouseRotate();
        behavior.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)behavior);
        behavior.setSchedulingBounds((Bounds)bounds);
        this.zoom = new MouseZoom();
        this.zoom.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)this.zoom);
        this.zoom.setSchedulingBounds((Bounds)bounds);
        MouseTranslate behavior3 = new MouseTranslate();
        behavior3.setTransformGroup(this.objTrans);
        this.objTrans.addChild((Node)behavior3);
        behavior3.setSchedulingBounds((Bounds)bounds);
        this.clicker = new ClickBehaviour(objRoot, this, (Bounds)bounds, 256);
        objRoot.addChild((Node)this.clicker);
        if (this.starPanel != null) {
            this.clicker.setStarPanel(this.starPanel);
        }
        Alpha mover = new Alpha(0, 4000L);
        this.rotator = new RotationInterpolator(mover, this.objTrans);
        this.rotator.setSchedulingBounds((Bounds)bounds);
        this.objTrans.addChild((Node)this.rotator);
        return objRoot;
    }

    public void setStarPanel(StarPanel p) {
        this.starPanel = p;
        if (this.clicker != null) {
            this.clicker.setStarPanel(p);
        }
    }

    public Sky3D() {
        super(null);
    }

    public void setupScene() {
        if (this.scene != null) {
            this.scene.detach();
            this.scene = null;
        }
        this.scene = this.createSceneGraph();
        if (this.uni == null) {
            this.uni = new SimpleUniverse((Canvas3D)this);
        }
    }

    protected void setScale(double d) {
        Transform3D scale = new Transform3D();
        float sc = (float)(0.6 / d);
        scale.setScale((double)sc);
        System.out.println("Scale " + sc + " d is " + d);
        this.objScale.setTransform(scale);
        this.zoom.setFactor(d / 10.0);
    }

    protected void setCenter(double ra, double dec, double d) {
        this.alpha = ra;
        this.delta = dec;
        this.center = Sky3D.makeVecParsec(ra, dec, d);
        Transform3D orig = new Transform3D();
        orig.set(this.center);
        this.objTrans.setTransform(orig);
        System.out.println("SetCenter " + this.center + "using " + ra + " " + dec + " " + d);
    }

    public Vector3d center() {
        return this.center;
    }

    public void setupScene(double ra, double dec, double d, double par) {
        this.setupScene();
        this.setScale(par);
        this.alpha = ra;
        this.delta = dec;
        this.tol = par;
        this.tolsquared = par * par;
        this.center = Sky3D.makeVecParsec(ra, dec, d);
    }

    public static Vector3d makeVecParsec(double alpha, double delta, double d) {
        double arad = Math.toRadians(alpha);
        double drad = Math.toRadians(delta);
        double cd = Math.cos(drad);
        double sd = Math.sin(drad);
        double sa = Math.sin(arad);
        double ca = Math.cos(arad);
        float x = (float)(d * cd * ca);
        float y = (float)(d * cd * sa);
        float z = (float)(d * sd);
        Vector3d vec = new Vector3d((double)x, (double)y, (double)z);
        return vec;
    }

    public static Vector3d makeVec(Star star) {
        double d = 1000.0 / star.getParalax();
        return Sky3D.makeVecParsec(star.getAlpha(), star.getDelta(), d);
    }

    public void showScene() {
        this.scene.compile();
        this.uni.addBranchGraph(this.scene);
        this.uni.getViewingPlatform().setNominalViewingTransform();
    }

    @Override
    public void addStar(Star star) {
        Vector3d spos = Sky3D.makeVec(star);
        spos.sub((Tuple3d)this.center);
        double x2y2z2 = Math.pow(spos.x, 2.0) + Math.pow(spos.y, 2.0) + Math.pow(spos.z, 2.0);
        if (x2y2z2 < this.tolsquared) {
            if (Constants.verbose > 3) {
                System.out.println("Star at " + spos + " size " + Star3D.calcSize(star));
            }
            Transform3D mat = new Transform3D();
            TransformGroup g = new TransformGroup(mat);
            g.setCapability(12);
            mat.set(spos);
            g.setTransform(mat);
            g.addChild((Node)new Star3D(star));
            this.objTrans.addChild((Node)g);
        }
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getDelta() {
        return this.delta;
    }

    @Override
    public double getTol() {
        return this.tol;
    }
}

