/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky;

import hipparcos.sky.Mag;
import hipparcos.sky.MagScale;
import hipparcos.sky.SkyArea;
import hipparcos.sky.Star2D;
import hipparcos.sky.StarList;
import hipparcos.sky.StarMover;
import hipparcos.tools.Browser;
import hipparcos.tools.MainFrame;
import hipparcos.tools.StarLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class ShowSky
extends Applet
implements ActionListener,
TextListener,
ItemListener {
    public SkyArea sky;
    public boolean stoped = true;
    public Label info1;
    public Label info2;
    public Label infoRA;
    public Label infoDEC;
    public Label infoHMS;
    public Label infoDMS;
    public Label width;
    public Label threshold;
    public Panel info;
    public Panel p2;
    public Panel controlp;
    public TextField raField;
    public TextField decField;
    public TextField thresField;
    public Choice choice;
    public String entry = "Enter RA Dec and field width in Degrees";
    public MagScale ms;
    public Checkbox tyc;
    public StarMover theMover = null;
    public Label info3;
    public Label infoYear;
    public boolean started = false;
    public String dataDir;
    public Checkbox tails;
    public Checkbox animate;
    public int factor = 2;
    public int tol = 4;
    public Choice speed;
    public StarList lister;
    protected String[] args = null;

    public ShowSky() {
    }

    public ShowSky(String[] args) {
        this.args = args;
    }

    public static void main(String[] argv) {
        ShowSky ap = new ShowSky();
        new MainFrame(ap, null, 990, 800);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 650);
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.info2 = new Label(this.entry);
        this.sky = new SkyArea();
        this.ms = new MagScale();
        this.info = new Panel();
        this.info.setLayout(new BorderLayout());
        Panel scale = new Panel();
        Label scaleText = new Label("Scale:");
        scaleText.setText("Scale:");
        scale.add(scaleText);
        scale.add(this.ms);
        this.controlp = new Panel();
        Label t2 = new Label("RA:");
        this.controlp.add("West", t2);
        this.raField = new TextField("00000000");
        if (this.args != null) {
            this.raField.setText(this.args[0]);
        }
        this.controlp.add("East", this.raField);
        Label t3 = new Label("Dec:");
        this.controlp.add("East", t3);
        this.decField = new TextField("00000");
        if (this.args != null) {
            this.decField.setText(this.args[1]);
        }
        this.controlp.add("East", this.decField);
        this.width = new Label("Width:");
        this.controlp.add("East", this.width);
        this.choice = new Choice();
        this.choice.addItem("1");
        this.choice.addItem("2");
        this.choice.addItem("3");
        this.choice.addItem("4");
        this.choice.addItem("5");
        this.choice.addItem("6");
        this.choice.addItem("8");
        this.choice.addItem("10");
        this.choice.addItem("15");
        this.choice.addItem("20");
        this.choice.addItem("25");
        this.choice.addItem("30");
        this.choice.addItem("35");
        this.controlp.add("East", this.choice);
        this.choice.select("6");
        this.choice.addItemListener(this);
        Mag.setFactor(3);
        this.threshold = new Label("V(lim):");
        this.controlp.add("East", this.threshold);
        this.thresField = new TextField("99");
        this.controlp.add("East", this.thresField);
        this.thresField.addTextListener(this);
        Button go = new Button("View");
        this.controlp.add("East", go);
        go.addActionListener(this);
        Button list = new Button("List");
        list.addActionListener(this);
        this.controlp.add("East", list);
        Button get = new Button("Get Info");
        get.addActionListener(this);
        this.tyc = new Checkbox("View TYC", null, true);
        this.tyc.addItemListener(this);
        this.tails = new Checkbox("Tails", null, true);
        this.tails.addItemListener(this);
        this.sky.setTails();
        this.infoYear = new Label("1991.0 (ICRS)");
        this.animate = new Checkbox("Animate", null, false);
        this.animate.addItemListener(this);
        Panel yearp = new Panel();
        yearp.setLayout(new FlowLayout(0, 0, 0));
        Label day = new Label("Year:");
        yearp.add(day);
        yearp.add(this.infoYear);
        this.theMover = new StarMover(this.sky, 2000);
        this.theMover.setInfo(this.infoYear);
        this.theMover.setDelay(490);
        Button reset = new Button("Reset");
        reset.addActionListener(this);
        this.speed = new Choice();
        this.speed.addItem("10");
        this.speed.addItem("100");
        this.speed.addItem("1000");
        this.speed.addItem("10000");
        this.speed.select("100");
        this.speed.addItemListener(this);
        Star2D.setYearStep(100);
        Label sp = new Label("Step:");
        Panel spPan = new Panel();
        spPan.add(sp);
        spPan.add(this.speed);
        this.p2 = new Panel();
        this.p2.setLayout(new GridLayout(17, 1));
        Label infoRed = new Label("Red=HIP only");
        Label infoWhite = new Label("White=TYC only");
        Label infoBlue = new Label("Blue=HIP+TYC");
        Label alpha = new Label("Alpha:");
        Label delta = new Label("Delta:");
        Label HMS = new Label("RA  :");
        Label DMS = new Label("Dec:");
        Label JD = new Label("J1991.25 (ICRS)");
        Label anim = new Label("   Animation");
        this.infoRA = new Label("000.000000000");
        this.infoDEC = new Label(" 00.000000000");
        this.infoHMS = new Label("+00 00 00");
        this.infoDMS = new Label("+00 00 00");
        this.p2.add(infoRed);
        this.p2.add(infoWhite);
        this.p2.add(infoBlue);
        this.p2.add(get);
        this.p2.add(this.tyc);
        Label blank = new Label(" ");
        this.p2.add(blank);
        this.p2.add(blank);
        this.p2.add(anim);
        this.p2.add(this.tails);
        this.p2.add(this.animate);
        this.p2.add(reset);
        this.p2.add(spPan);
        this.p2.add(yearp);
        this.p2.add(blank);
        this.p2.add(blank);
        Panel al = new Panel();
        al.setLayout(new FlowLayout(0, 0, 0));
        al.add(alpha);
        al.add(this.infoRA);
        this.p2.add(al);
        Panel dl = new Panel();
        dl.setLayout(new FlowLayout(0, 0, 0));
        dl.add(delta);
        dl.add(this.infoDEC);
        this.p2.add(dl);
        Panel hms = new Panel();
        hms.setLayout(new FlowLayout(0, 0, 0));
        hms.add(HMS);
        hms.add(this.infoHMS);
        this.p2.add(hms);
        Panel dms = new Panel();
        dms.setLayout(new FlowLayout(0, 0, 0));
        dms.add(DMS);
        dms.add(this.infoDMS);
        this.p2.add(dms);
        this.sky.infoInit(this.infoRA, this.infoDEC, this.infoHMS, this.infoDMS);
        this.add("North", scale);
        this.add("East", this.p2);
        this.add("Center", this.sky);
        this.info.add("Center", this.controlp);
        this.info.add("South", this.info2);
        this.add("South", this.info);
        this.lister = new StarList(this.sky);
    }

    public void populate(String ras, String decs, String tols) {
        try {
            double ra = new Double(ras);
            double dec = new Double(decs);
            if (dec > 90.0 || dec < -90.0) {
                throw new Exception();
            }
            double tol = new Double(tols);
            this.populate(ra, dec, tol /= 2.0);
        }
        catch (Exception e) {
            this.info2.setText("Ensure RA(0-360) and Dec(<90 >-90) are valid");
            System.err.println("Ensure RA and Dec are valid :" + e);
        }
    }

    public String getInfo() {
        return "Sky Plot by William O'Mullane for the European Space Agency";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.info2.setText(this.entry);
        String label = e.getActionCommand();
        if (label == "Quit") {
            System.exit(0);
        }
        if (label == "Reset") {
            this.theMover.reset();
            this.sky.repaint();
        }
        if (label == "List") {
            this.lister.setVisible(true);
            this.lister.refresh();
        }
        if (label == "View") {
            this.populate(this.raField.getText(), this.decField.getText(), this.choice.getSelectedItem());
        }
        if (label == "Get Info") {
            Star2D theStar = this.sky.getLastSelected();
            if (theStar != null) {
                System.out.println("Go get " + theStar.getId());
                this.info2.setText(Browser.goTo(theStar.makeUrl()));
            } else {
                this.info2.setText("Select a source first");
            }
        }
    }

    public void populate(double ra, double dec, double tol) {
        try {
            this.sky.init(ra, dec, tol);
            StarLoader starLoader = new StarLoader(this.sky, 0.0, !this.tyc.getState());
        }
        catch (Exception e) {
            System.err.println("Could not access Sky data :" + e);
        }
    }

    @Override
    public void textValueChanged(TextEvent evt) {
        try {
            double thres = new Double(this.thresField.getText());
            Star2D.setThreshold(thres);
            this.sky.replotAll(thres);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        int ch;
        this.info2.setText(this.entry);
        ItemSelectable cb = evt.getItemSelectable();
        if (cb == this.tyc) {
            if (evt.getStateChange() == 1) {
                this.sky.unSetViewHipOnly();
            } else {
                this.sky.setViewHipOnly();
            }
        }
        if (cb == this.animate) {
            if (evt.getStateChange() == 1) {
                this.theMover.start();
            } else {
                this.theMover.stop();
            }
        }
        if (cb == this.tails) {
            if (evt.getStateChange() == 1) {
                this.sky.setTails();
            } else {
                this.sky.unSetTails();
            }
        }
        if (cb == this.speed) {
            ch = new Integer(this.speed.getSelectedItem());
            Star2D.setYearStep(ch);
        }
        if (cb == this.choice) {
            ch = new Integer(this.choice.getSelectedItem());
            Mag.setFactor(2);
            switch (ch) {
                case 1: {
                    Mag.setFactor(8);
                    break;
                }
                case 2: {
                    Mag.setFactor(7);
                    break;
                }
                case 3: {
                    Mag.setFactor(6);
                    break;
                }
                case 4: {
                    Mag.setFactor(5);
                    break;
                }
                case 5: {
                    Mag.setFactor(4);
                    break;
                }
                case 6: {
                    Mag.setFactor(3);
                    break;
                }
                case 8: {
                    Mag.setFactor(3);
                    break;
                }
                case 10: {
                    Mag.setFactor(2);
                    break;
                }
                case 15: {
                    Mag.setFactor(2);
                    break;
                }
                case 20: {
                    Mag.setFactor(2);
                    break;
                }
                case 25: {
                    Mag.setFactor(2);
                }
            }
            this.ms.repaint();
        }
    }
}

