/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.sky;

class Mag {
    private double mag;
    private static double c = 0.105;
    private static int factor = 6;
    private static int maxPix = 40;
    private static int minPix = 40;
    private int pixelDiameter = 0;

    public Mag(double mag) {
        this.mag = mag;
        this.calculatePixelDiameter();
    }

    private void calculatePixelDiameter() {
        this.pixelDiameter = (int)Math.ceil((double)factor * Math.pow(10.0, c * (9.3 - this.mag)));
        if (this.pixelDiameter < 2) {
            this.pixelDiameter = 2;
        }
        if (this.pixelDiameter > 40) {
            this.pixelDiameter = 40;
        }
    }

    public double getMag() {
        return this.mag;
    }

    public int getPixelDiameter() {
        return this.pixelDiameter;
    }

    public String toString() {
        return new Double(this.mag).toString();
    }

    public static boolean setFactor(int f) {
        factor = f;
        return true;
    }

    public static int getFactor() {
        return factor;
    }

    public static boolean setConstant(double c) {
        Mag.c = c;
        return true;
    }

    public static double getConstant() {
        return c;
    }
}

