/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.plot;

import hipparcos.plot.DPoint;
import hipparcos.plot.Plot;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class SimplePlot
extends Plot {
    public Vector points;
    public boolean gotOne = false;
    public Color plotcol;
    public boolean plotZeroLine = true;
    public static Color zeroLineColor = new Color(255, 105, 255);

    public SimplePlot(String xlabel, String ylabel, double lowX, double highX, double lowY, double highY, Color col) {
        this.setXlabel(xlabel);
        this.setYlabel(ylabel);
        this.plotcol = col;
        this.init(lowX, highX, lowY, highY);
    }

    public void resetGraph() {
        this.points = new Vector();
    }

    public void init(double lowX, double highX, double lowY, double highY) {
        this.gotOne = false;
        this.minx = lowX;
        this.maxx = highX;
        this.miny = lowY;
        this.maxy = highY;
        this.xstep = 1.0;
        this.ystep = 1;
        this.numberStep = 1;
        this.ynumberStep = 5;
        this.points = new Vector();
    }

    public void addPoint(DPoint p) {
        this.gotOne = true;
        if (this.points != null) {
            this.points.addElement(p);
        }
        this.repaint();
    }

    @Override
    public void plotGraph(Graphics g) {
        if (this.gotOne && this.points != null) {
            if (this.plotZeroLine) {
                this.plotZero(g);
            }
            g.setColor(this.plotcol);
            Enumeration e = this.points.elements();
            while (e.hasMoreElements()) {
                DPoint p = (DPoint)e.nextElement();
                this.plotPoint(p, g);
            }
        } else {
            g.setColor(Color.red);
            g.drawString(" No data", 30, this.getSize().height / 2);
        }
    }

    public void plotZero(Graphics g) {
        int y1 = this.calcY(0.0);
        int x1 = this.calcX(this.minx);
        int y2 = y1;
        int x2 = this.calcX(this.maxx);
        int xi = this.calcX(this.minx);
        g.setColor(zeroLineColor);
        g.drawLine(x1, y1, x2, y2);
    }
}

