/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.plot;

import hipparcos.plot.DPoint;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class Plot
extends Canvas {
    double scaleX;
    double scaleY;
    public double minx;
    public double miny;
    public double maxx;
    public double maxy;
    public int topRule;
    public int bottomRule;
    public int leftRule;
    public int rightRule;
    public int dheight;
    public int ystep = -1;
    public int numberStep = 5;
    public int ynumberStep = 5;
    public double xstep = -1.0;
    public int pointSize = 4;
    private String botText;
    private String leftText;
    private boolean inited = false;

    private void init() {
        this.topRule = 20;
        this.bottomRule = 30;
        this.rightRule = 20;
        this.leftRule = 25;
        this.setBackground(Color.white);
        this.minx = 0.0;
        this.maxx = 10.0;
        this.miny = 0.0;
        this.maxy = 10.0;
        this.botText = new String("X axis");
        this.leftText = new String("Y axis");
        this.inited = true;
    }

    public Plot() {
        this.init();
    }

    public void setScales() {
        int gHeight;
        Dimension d = this.getSize();
        int gWidth = d.width - this.leftRule - this.rightRule;
        this.dheight = gHeight = d.height - this.bottomRule - this.topRule;
        this.scaleX = (this.maxx - this.minx) / (double)gWidth;
        this.scaleY = (this.maxy - this.miny) / (double)gHeight;
        if (this.xstep <= -1.0) {
            this.xstep = this.getStep(this.scaleX);
            this.numberStep = this.getNumberStep(this.scaleX);
        }
        if (this.ystep == -1) {
            this.ystep = this.getStep(this.scaleY);
            this.ynumberStep = this.getNumberStep(this.scaleY);
        }
    }

    public int getStep(double scale) {
        int ret = 1;
        if (scale <= 2.0) {
            ret = 50;
        }
        if (scale <= 1.0) {
            ret = 10;
        }
        if (scale < 0.1) {
            ret = 1;
        }
        return ret;
    }

    public int getNumberStep(double scale) {
        int ret = 1;
        if (scale <= 2.0) {
            ret = 50;
        }
        if (scale <= 1.0) {
            ret = 10;
        }
        if (scale < 0.1) {
            ret = 5;
        }
        return ret;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.inited) {
            this.init();
        }
        this.drawRulers(g);
        this.plotGraph(g);
    }

    public void plotGraph(Graphics g) {
        g.setColor(Color.red);
        g.drawString(" Not Implemented", 30, this.getSize().height / 2);
    }

    public int calcX(double d) {
        Double ret = new Double((double)this.leftRule + (d - this.minx) / this.scaleX);
        return ret.intValue();
    }

    public int calcY(double d) {
        Double ret = new Double((d - this.miny) / this.scaleY);
        return this.topRule + this.dheight - ret.intValue();
    }

    private void drawRulers(Graphics g) {
        int posTick;
        int cShift = 9;
        this.setScales();
        Float stF = new Float(this.maxy + this.maxy % (double)this.ystep);
        int highY = stF.intValue();
        stF = new Float(this.miny - this.miny % (double)this.ystep);
        int lowY = stF.intValue();
        int posHighY = this.calcY(highY) + cShift / 2;
        int posLowY = this.calcY(lowY) + cShift / 2;
        stF = new Float(this.maxx - this.maxx % this.xstep);
        int highX = stF.intValue();
        stF = new Float(this.minx - this.minx % this.xstep);
        int lowX = stF.intValue();
        int posHighX = this.calcX(highX) - cShift / 2;
        int posLowX = this.calcX(lowX) - cShift;
        g.setColor(Color.black);
        g.drawString(this.leftText, 1, 12);
        Dimension d = this.getSize();
        Double center = new Double(d.width / 2 - this.botText.length() / 2 * 7);
        g.drawString(this.botText, center.intValue(), d.height - cShift / 2);
        g.drawLine(this.leftRule - 1, this.topRule, this.leftRule - 1, d.height - this.bottomRule);
        g.drawLine(this.leftRule - 1, d.height - this.bottomRule, d.width - this.rightRule, d.height - this.bottomRule);
        int endTick = highY - highY % this.ystep;
        for (int tick = lowY - lowY % this.ystep; tick <= endTick; tick += this.ystep) {
            posTick = this.calcY(tick);
            g.drawLine(this.leftRule - 5, posTick, this.leftRule, posTick);
            if (tick % this.ynumberStep != 0) continue;
            g.drawString("" + tick, 3, posTick + cShift / 2);
        }
        endTick = (int)((double)highX - (double)highX % this.xstep);
        for (double dtick = (double)lowX - (double)lowX % this.xstep; dtick <= (double)endTick; dtick += this.xstep) {
            posTick = this.calcX(dtick);
            g.drawLine(posTick, d.height - this.bottomRule, posTick, d.height - this.bottomRule + 5);
            if (dtick % (double)this.numberStep != 0.0) continue;
            Double t = new Double(dtick);
            g.drawString("" + t.intValue(), posTick - cShift / 2, d.height - 14);
        }
    }

    public void setXlabel(String l) {
        this.botText = l;
    }

    public void setYlabel(String l) {
        this.leftText = l;
    }

    public void plotPoint(double rx, double ry, Graphics g) {
        int x = this.calcX(rx);
        int y = this.calcY(ry);
        Double offd = new Double(this.pointSize / 2);
        int off = offd.intValue();
        g.fillOval(x - off, y - off, this.pointSize, this.pointSize);
    }

    public void plotPoint(DPoint p, Graphics g) {
        this.plotPoint(p.getX(), p.getY(), g);
    }
}

