/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.plot;

import hipparcos.plot.Plot;
import java.awt.Color;
import java.awt.Graphics;

public class Histogram
extends Plot {
    private int[] occurences;
    private boolean gotOne = false;
    private Color plotcol;

    public Histogram(String xlabel, String ylabel, int low, int high, double step, Color col) {
        this.setXlabel(xlabel);
        this.setYlabel(ylabel);
        this.plotcol = col;
        this.init(low, high, step);
    }

    public void resetGraph() {
        this.miny = 0.0;
        this.maxy = 10.0;
        if (this.occurences != null) {
            for (int i = 0; i < this.occurences.length; ++i) {
                this.occurences[i] = 0;
            }
        }
    }

    public void init(int low, int high, double step) {
        this.gotOne = false;
        this.minx = low;
        this.maxx = high;
        this.miny = 0.0;
        this.maxy = 10.0;
        this.xstep = step;
        this.numberStep = 5;
        Double nogrps = new Double((double)(high - low) / step);
        this.occurences = new int[nogrps.intValue()];
    }

    public void addOccurence(double o) {
        this.gotOne = true;
        int which = 0;
        double category = this.minx + this.xstep;
        while (category < o && category < this.maxx) {
            category += this.xstep;
            ++which;
        }
        while (which >= this.occurences.length) {
            --which;
        }
        int n = which;
        this.occurences[n] = this.occurences[n] + 1;
        if ((double)this.occurences[which] > this.maxy) {
            this.maxy = this.occurences[which];
            this.ystep = -1;
        }
        this.repaint();
    }

    @Override
    public void plotGraph(Graphics g) {
        if (this.gotOne) {
            g.setColor(this.plotcol);
            double categ = this.minx;
            for (int i = 0; i < this.occurences.length; ++i) {
                this.plotBar(categ, this.occurences[i], g);
                categ += this.xstep;
            }
        } else {
            g.setColor(Color.red);
            g.drawString(" No data", 30, this.getSize().height / 2);
        }
    }

    public void plotBar(double cat, int height, Graphics g) {
        int x = this.calcX(cat);
        int w = this.calcX(cat + this.xstep) - x;
        int y = this.calcY(height);
        int h = this.calcY(this.miny) - y;
        g.fillRect(x, y, w, h);
    }
}

