/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.hipi.PlotHipi;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class PhasePanel
extends Panel {
    private PlotHipi app;
    private TextField phaseField;
    private double step;

    public PhasePanel(String title, String startValue, PlotHipi app) {
        this.setLayout(new FlowLayout());
        Label enterPhase = new Label(title);
        this.add("West", enterPhase);
        this.phaseField = new TextField(7);
        this.phaseField.setText(startValue);
        this.add("East", this.phaseField);
        Button upButton = new Button("inc");
        this.add("East", upButton);
        Button downButton = new Button("dec");
        this.add("East", downButton);
        Label t3 = new Label("Step:");
        this.add("East", t3);
        Choice choice = new Choice();
        choice.addItem(" 3");
        choice.addItem(" 2");
        choice.addItem(" 1");
        choice.addItem(" 0.1");
        choice.addItem(" 0.01");
        choice.addItem(" 0.001");
        choice.addItem(" 0.0001");
        choice.addItem(" 0.00001");
        this.add("East", choice);
        choice.select(" 0.1");
        this.step = 0.1;
        this.app = app;
    }

    @Override
    public boolean action(Event evt, Object obj) {
        switch (evt.id) {
            case 1001: {
                String tmpS;
                if (evt.target instanceof TextField) {
                    Double period = Double.valueOf((String)evt.arg);
                    this.app.setPhase(period);
                }
                if (evt.target instanceof Choice) {
                    Double val = Double.valueOf((String)evt.arg);
                    this.step = val;
                }
                if (!(evt.target instanceof Button)) break;
                Button theButton = (Button)evt.target;
                String label = theButton.getLabel();
                double presper = this.app.getPhase();
                Double period = new Double(0.0);
                if (label == "inc") {
                    period = new Double(presper + this.step + 5.0E-6);
                }
                if (label == "dec") {
                    period = new Double(presper - this.step - 5.0E-6);
                }
                if ((tmpS = period.toString()).length() > 7) {
                    tmpS = tmpS.substring(0, 7);
                }
                this.phaseField.setText(tmpS);
                this.app.setPhase(new Double(tmpS));
            }
        }
        return true;
    }
}

