/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

class Legend
extends Canvas {
    private Color baryColour;

    public void init() {
        this.setBackground(Color.white);
    }

    public Legend(Color baryColour) {
        this.baryColour = baryColour;
        this.init();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(80, 400);
    }

    @Override
    public void paint(Graphics g) {
        int xoff = 4;
        int yoff = 15;
        g.setColor(Color.blue);
        Dimension d = this.size();
        g.drawRect(1, 1, d.width - 2, d.height - 2);
        g.setColor(Color.blue);
        g.drawString("FAST Data:", xoff, yoff);
        g.drawString("Fitted", xoff, yoff += 15);
        g.fillOval(xoff + 60, yoff - 8, 4, 4);
        g.drawString("Rejected", xoff, yoff += 15);
        g.drawOval(xoff + 60, yoff - 8, 4, 4);
        g.setColor(Color.red);
        g.drawString("NDAC Data:", xoff, yoff += 35);
        g.drawString("Fitted", xoff, yoff += 15);
        g.fillOval(xoff + 60, yoff - 8, 4, 4);
        g.drawString("Rejected", xoff, yoff += 15);
        g.drawOval(xoff + 60, yoff - 8, 4, 4);
        g.setColor(this.baryColour);
        g.drawString("Barycentric", xoff, yoff += 45);
        g.drawString("motion:", xoff, yoff += 15);
        g.drawLine(xoff, yoff += 5, d.width - xoff, yoff);
        g.drawString("step: 0.1yr", xoff, yoff += 15);
        g.setColor(Color.green);
        g.drawString("Solution:", xoff, yoff += 45);
        yoff += 25;
        int step = 6;
        int rside = d.width - xoff;
        rside -= xoff;
        for (int i = xoff; i < rside; ++i) {
            double x = (double)(12 * i) / 57.3;
            double sinX = Math.sin(x);
            Double DsinX = new Double(sinX * 15.0);
            int y = yoff + DsinX.intValue();
            g.fillOval(i, y, 4, 4);
        }
        g.drawString("step: 0.1yr", xoff, yoff += 35);
        g.setColor(Color.black);
        g.drawString("Fitted Point", xoff, yoff += 45);
        g.drawString("connected", xoff, yoff += 15);
        g.drawString("to 1-d ", xoff, yoff += 15);
        g.drawString("observation:", xoff, yoff += 15);
        g.fillOval(xoff + 10, (yoff += 25) - 2, 4, 4);
        g.drawLine(xoff + 50, yoff - 7, xoff + 50, yoff + 7);
        g.drawLine(xoff + 10, yoff, xoff + 50, yoff);
    }
}

