/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import java.util.Enumeration;
import java.util.Vector;

public class HIPI {
    private boolean initVals = false;
    private double ra;
    private double dec;
    private double sinra;
    private double cosra;
    private double sindec;
    private double cosdec;
    public Vector abscissae;
    public int ihip = 0;
    public double mag;
    public double radeg;
    public double decdeg;
    public double par;
    public double pma;
    public double pmd;
    public String code;
    public int nobs;
    private String gap = new String("       ");

    public void initVals() {
        this.initVals = true;
        this.ra = this.radeg / 57.29578;
        this.dec = this.decdeg / 57.29578;
        this.sinra = Math.sin(this.ra);
        this.cosra = Math.cos(this.ra);
        this.sindec = Math.sin(this.dec);
        this.cosdec = Math.cos(this.dec);
    }

    public HIPI() {
        this.abscissae = new Vector();
    }

    public String getInfoText1() {
        if (this.ihip != 0) {
            String ret = new String("HIP ");
            ret = ret + this.ihip + this.gap;
            ret = ret + "RA(deg): " + this.radeg + this.gap;
            ret = ret + "Dec(deg): " + this.decdeg + this.gap;
            ret = ret + "Magnitude (Hp): " + this.mag;
            return ret;
        }
        return "No Data";
    }

    public String getInfoText2() {
        if (this.ihip != 0) {
            String ret = new String(" ");
            ret = ret + "Solution Code: " + this.code + this.gap;
            ret = ret + "par: " + this.par + this.gap;
            ret = ret + "pma: " + this.pma + this.gap;
            ret = ret + "pmd: " + this.pmd + this.gap;
            ret = ret + "nobs(FAST+NDAC): " + this.nobs;
            return ret;
        }
        return "No Data";
    }

    public String toString() {
        String ret = new String("HIP ");
        ret = ret + this.ihip + "|" + this.mag + "|" + this.radeg + "|" + this.decdeg + "|" + this.par + "|" + this.pma + "|" + this.pmd + "|" + this.code + "\n";
        Enumeration e = this.abscissae.elements();
        while (e.hasMoreElements()) {
            ret = ret + e.nextElement() + "\n";
        }
        return ret;
    }

    public double getRa() {
        return this.ra;
    }

    public double getDec() {
        return this.dec;
    }

    public double sinRa() {
        return this.sinra;
    }

    public double sinDec() {
        return this.sindec;
    }

    public double cosDec() {
        return this.cosdec;
    }

    public double cosRa() {
        return this.cosra;
    }

    public int getHipNumber() {
        return this.ihip;
    }
}

