/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.hipi;

import hipparcos.tools.VectorPosition;

public class Earth {
    private static double omega = 1.990986574074074E-7;
    private static double e = 0.016714;
    private static double g0 = -0.04128;
    private static double au = 1.496E11;
    private static double[][] c = new double[][]{{5.40817E8, -3.34118E10, -1.45868E11}, {-2.02315E9, 1.33781E11, -3.06652E10}, {-8.83589E8, 5.80048E10, -1.32951E10}};

    static double[] cearth(double year) {
        double[] ret = new double[]{0.0, 0.0, 0.0};
        double t = (year - 1988.0) * 365.25 * 86400.0;
        double arg = omega * t + g0;
        arg += e * Math.sin(arg);
        double co = Math.cos(arg);
        double si = Math.sin(arg);
        for (int i = 0; i < 3; ++i) {
            ret[i] = (c[i][0] + c[i][1] * co + c[i][2] * si) / au;
        }
        return ret;
    }

    public static VectorPosition where(double year) {
        double[] posArray = Earth.cearth(year);
        return new VectorPosition(posArray[0], posArray[1], posArray[2]);
    }
}

