/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.curve;

import java.util.Enumeration;
import java.util.Vector;

public class HIP_EP {
    public Vector Epoints;
    public int hipNumber;
    public double medianMagnitude;
    public double standardErrorMedianMagnitude;
    public double V_I;
    public double solutionPeriod;
    public double sPeriodLit;
    public double refferenceEpoch;
    public double maxError;
    public double minHp;
    public double maxHp;
    public double fifth;
    public double nintyfifth;
    public String variabilityType;
    public String component;
    public String gap = new String("       ");

    private void init() {
        this.hipNumber = 0;
        this.Epoints = new Vector();
    }

    public HIP_EP() {
        this.init();
    }

    public String getInfoText() {
        if (this.hipNumber != 0) {
            String ret = new String("HIP ");
            ret = ret + this.hipNumber + this.gap;
            ret = ret + "Ref. Epoch: " + this.refferenceEpoch + this.gap;
            ret = ret + "Ref. Period(days): " + this.solutionPeriod + this.gap;
            ret = ret + "Med. Mag.: " + this.medianMagnitude + this.gap;
            ret = ret + "5th %tile: " + this.fifth + this.gap;
            ret = ret + "95th %tile: " + this.nintyfifth;
            return ret;
        }
        return "No Data";
    }

    public String getInfoText1() {
        if (this.hipNumber != 0) {
            String ret = new String("HIP ");
            ret = ret + this.hipNumber + this.gap + this.gap;
            ret = ret + "Reference Epoch: " + this.refferenceEpoch + this.gap;
            ret = ret + "Reference Period(days): " + this.solutionPeriod + this.gap;
            ret = ret + "Literature Period(days): " + this.sPeriodLit;
            return ret;
        }
        return "No Data";
    }

    public String getInfoText2() {
        if (this.hipNumber != 0) {
            String ret = new String("");
            ret = ret + "Median Magnitude(red line): " + this.medianMagnitude + this.gap + this.gap;
            ret = ret + "5th Percentile: " + this.fifth + this.gap + this.gap;
            ret = ret + "95th Percentile: " + this.nintyfifth;
            return ret;
        }
        return "";
    }

    public String toString() {
        String ret = new String("HIP ");
        ret = ret + this.hipNumber + " SolvedPeriod:" + this.solutionPeriod + "\n";
        Enumeration e = this.Epoints.elements();
        while (e.hasMoreElements()) {
            ret = ret + e.nextElement() + "\n";
        }
        return ret;
    }

    public double getMaxError() {
        return this.maxError;
    }

    public double getMinHp() {
        return this.minHp;
    }

    public double getMaxHp() {
        return this.maxHp;
    }

    public double getHpRange() {
        return this.maxHp - this.minHp;
    }

    public double getSolutionPeriod() {
        if (this.solutionPeriod > 0.0) {
            return this.solutionPeriod;
        }
        return this.sPeriodLit;
    }

    public double getMedianMagnitude() {
        return this.medianMagnitude;
    }

    public double getRefferenceEpoch() {
        return this.refferenceEpoch;
    }

    public int getHipNumber() {
        return this.hipNumber;
    }

    public Vector getEPpoints() {
        return this.Epoints;
    }
}

