/*
 * Decompiled with CFR 0.152.
 */
package hipparcos.curve;

import hipparcos.curve.BadlyFormatedEPstring;
import hipparcos.curve.EPpoint;
import hipparcos.curve.HIP_EP;
import hipparcos.tools.Constants;
import hipparcos.tools.DelimitedLine;
import hipparcos.tools.Factory;
import hipparcos.tools.HIPproperties;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class HIPEPFactory
extends Factory {
    public static HIP_EP get(int hipid) throws Exception {
        HIPEPFactory fac = new HIPEPFactory(hipid);
        HIP_EP h = (HIP_EP)fac.getObj();
        HIPEPFactory.getLiteraturePeriod(h);
        return h;
    }

    public static HIP_EP get(String fn) throws Exception {
        HIPEPFactory fac = new HIPEPFactory(fn);
        if (Constants.verbose > 4) {
            System.out.println("Made factory for:" + fn);
        }
        HIP_EP t = (HIP_EP)fac.getObj();
        if (Constants.verbose > 4) {
            System.out.println(" got:" + t);
        }
        return t;
    }

    public HIPEPFactory(int hipid) {
        super(hipid, "shipep", "hipepId");
    }

    public HIPEPFactory(String filename) {
        this.loadFromFile(filename);
    }

    protected boolean loadFromFile(String fileName) {
        try {
            if (Constants.verbose > 2) {
                System.out.println("Loading " + fileName);
            }
            InputStreamReader istream = null;
            istream = fileName.startsWith("http") || fileName.startsWith("HTTP") ? new InputStreamReader(new URL(fileName).openStream()) : new InputStreamReader(new FileInputStream(fileName));
            this.dstream = new BufferedReader(istream);
            return true;
        }
        catch (Exception e) {
            System.err.println("loadEPfromFile: " + e);
            return false;
        }
    }

    @Override
    public Object getObj() throws Exception {
        HIP_EP hipep = new HIP_EP();
        String str = this.dstream.readLine();
        if (Constants.verbose > 5) {
            System.out.println("Skip:" + str);
        }
        str = this.dstream.readLine();
        if (Constants.verbose > 5) {
            System.out.println("Split:" + str);
        }
        DelimitedLine hinfo = new DelimitedLine(str, '|');
        try {
            hipep.hipNumber = hinfo.getNextInt();
            hipep.component = hinfo.getNextString();
            hipep.V_I = hinfo.getNextDouble();
            String skip = hinfo.getNextString();
            skip = hinfo.getNextString();
            hipep.medianMagnitude = hinfo.getNextDouble();
            hipep.standardErrorMedianMagnitude = hinfo.getNextDouble();
            hipep.fifth = hinfo.getNextDouble();
            hipep.nintyfifth = hinfo.getNextDouble();
            try {
                hipep.solutionPeriod = hinfo.getNextDouble();
            }
            catch (Exception e) {
                hipep.solutionPeriod = 0.0;
            }
            try {
                hipep.refferenceEpoch = hinfo.getNextDouble();
            }
            catch (Exception e) {
                hipep.refferenceEpoch = 0.0;
            }
        }
        catch (Exception e) {
            System.err.println("can not create HIPEP: Bad Header Line " + e);
            e.printStackTrace();
        }
        try {
            if (Constants.verbose > 5) {
                System.out.println("Reading transits");
            }
            str = this.dstream.readLine();
            boolean first = true;
            boolean finished = false;
            str = this.dstream.readLine();
            while (!finished) {
                block22: {
                    try {
                        if (Constants.verbose > 5) {
                            System.out.println("parsing " + str);
                        }
                        EPpoint p = new EPpoint(str);
                        if (first) {
                            first = false;
                            hipep.minHp = p.Hp;
                            hipep.maxHp = p.Hp;
                            hipep.maxError = p.standardError;
                        } else {
                            if (p.Hp > hipep.maxHp) {
                                hipep.maxHp = p.Hp;
                            }
                            if (p.Hp < hipep.minHp) {
                                hipep.minHp = p.Hp;
                            }
                            if (p.standardError > hipep.maxError) {
                                hipep.maxError = p.standardError;
                            }
                        }
                        hipep.Epoints.addElement(p);
                    }
                    catch (BadlyFormatedEPstring e) {
                        if (str == null) break block22;
                        if (str.startsWith("</pre") || str.startsWith("</PRE")) {
                            finished = true;
                        }
                        if (Constants.verbose <= 2) break block22;
                        System.err.println("Discarded " + str + " Not an EP point" + e);
                    }
                }
                str = this.dstream.readLine();
                finished = finished || str == null;
            }
        }
        catch (IOException e) {
            System.err.println("can not load object: InputStream Error  " + e);
        }
        if (Constants.verbose > 3) {
            System.out.println("Loaded - " + hipep.hipNumber);
        }
        return hipep;
    }

    public static void getLiteraturePeriod(HIP_EP hipep) {
        if (hipep.hipNumber > 0) {
            String hipId = new Integer(hipep.hipNumber).toString();
            hipep.sPeriodLit = !disk ? HIPEPFactory.getPeriodWWW(hipId) : HIPEPFactory.getPeriodDisk(hipId);
        }
    }

    protected static double getPeriodDisk(String hipid) {
        try {
            Runtime rt;
            Process p;
            InputStreamReader istream;
            BufferedReader dstream;
            String str;
            String bins = HIPproperties.getProperty("bins");
            String cmd = bins + "/shipva -tq " + hipid;
            if (Constants.verbose > 1) {
                System.out.println("Running " + cmd + ".");
            }
            if ((str = (dstream = new BufferedReader(istream = new InputStreamReader((p = (rt = Runtime.getRuntime()).exec(cmd)).getInputStream()))).readLine()).indexOf("not found") == -1) {
                DelimitedLine l = new DelimitedLine(str, '|');
                for (int i = 0; i < 17; ++i) {
                    str = l.getNextString();
                }
                return l.getNextDouble();
            }
        }
        catch (Exception e) {
            System.err.println(" could not getLiteraturePeriod: " + e);
        }
        return 0.0;
    }

    protected static double getPeriodWWW(String hipid) {
        try {
            String theUrl = HIPproperties.getProperty("hipurl");
            theUrl = theUrl + "?p18=" + hipid;
            InputStreamReader istream = new InputStreamReader(new URL(theUrl).openStream());
            BufferedReader d = new BufferedReader(istream);
            String str = d.readLine();
            if (str.indexOf("not found") == -1) {
                return new Double(str.trim());
            }
        }
        catch (Exception e) {
            System.err.println(" could not getLiteraturePeriod: " + e);
        }
        return 0.0;
    }
}

