/*
 * Decompiled with CFR 0.152.
 */
package hipparcos;

import hipparcos.curve.LightCurve;
import hipparcos.hipi.PlotHipi;
import hipparcos.sky.ShowSky;
import hipparcos.tools.Browser;
import hipparcos.tools.MainFrame;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;

public class StartPanel
extends Frame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private MainFrame curve = null;
    private MainFrame sky = null;
    private MainFrame hipi = null;
    private static String[] args = new String[]{"5", "0.00996534", "40.59122440"};

    public StartPanel() {
        this.init();
    }

    private void init() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("Menu");
        m.add(new MenuItem("Restart"));
        m.add(new MenuItem("Quit"));
        mb.add(m);
        this.setMenuBar(mb);
        this.setTitle("Hipparcos Java StartPanel");
        Properties props = System.getProperties();
        props.put("browser", "hipparcos.tools.StartPanel");
        props.put("browser.version", "Apr2016");
        props.put("browser.vendor", "European Space Agency");
        props.put("browser.vendor.url", "http://www.cosmos.esa.int/");
        this.setLayout(new BorderLayout());
        this.pack();
        this.validate();
        Panel pan = new Panel();
        pan.setLayout(new GridLayout(3, 1));
        Button showSky = new Button("Show Sky");
        showSky.setActionCommand("ShowSky");
        showSky.addActionListener(this);
        pan.add(showSky);
        Button curve = new Button("Light Curve");
        curve.setActionCommand("LightCurve");
        curve.addActionListener(this);
        pan.add(curve);
        Button hipi = new Button("Intermediate Data");
        hipi.setActionCommand("PlotHipi");
        hipi.addActionListener(this);
        pan.add(hipi);
        this.add("Center", pan);
        this.setSize(400, 400);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvent) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            StartPanel.args = args;
        }
        Browser.setMainFrame();
        new StartPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String[] largs;
        String label = e.getActionCommand();
        if (label == "Quit") {
            System.exit(0);
        }
        if (label == "PlotHipi") {
            if (this.hipi == null) {
                largs = new String[]{"id=" + args[0]};
                this.hipi = new MainFrame(new PlotHipi(), largs, 730, 570);
            } else {
                this.hipi.toFront();
            }
        }
        if (label == "ShowSky") {
            if (this.sky == null) {
                largs = new String[]{args[1], args[2]};
                ShowSky ss = new ShowSky(largs);
                this.sky = new MainFrame(ss, null, 990, 800);
            } else {
                this.sky.toFront();
            }
        }
        if (label == "LightCurve") {
            if (this.curve == null) {
                this.curve = new MainFrame(new LightCurve(), null, 800, 450);
            } else {
                this.curve.toFront();
            }
        }
    }
}

