/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicColors;
import edu.colorado.phet.fourier.view.tools.AbstractHarmonicMeasurementTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Point2D;

public class HarmonicPeriodTool
extends AbstractHarmonicMeasurementTool {
    private static final char SYMBOL = MathStrings.C_PERIOD;

    public HarmonicPeriodTool(Component component, Harmonic harmonic, Chart chart) {
        super(component, harmonic, chart);
    }

    protected void updateTool() {
        Harmonic harmonic = this.getHarmonic();
        Chart chart = this.getChart();
        String string = String.valueOf(harmonic.getOrder() + 1);
        this.setLabel("<html>" + SYMBOL + "<sub>" + string + "</sub></html>");
        Color color = HarmonicColors.getInstance().getColor(harmonic);
        this.setFillColor(color);
        double d = 1.0 / (double)(harmonic.getOrder() + 1);
        Point2D point2D = chart.transformDouble(0.0, 0.0);
        Point2D point2D2 = chart.transformDouble(d, 0.0);
        float f = (float)(point2D2.getX() - point2D.getX());
        this.setToolWidth(f);
    }
}

