/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.game;

import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.HarmonicPlot;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicColors;
import edu.colorado.phet.fourier.view.discrete.DiscreteHarmonicsChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;

public class GameHarmonicsView
extends GraphicLayerSet
implements HarmonicFocusListener {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 216);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 115);
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.336901521971921, 0.5, 1.336901521971921);
    private static final Dimension CHART_SIZE = new Dimension(540, 135);
    private static final Stroke WAVE_NORMAL_STROKE = new BasicStroke(1.0f);
    private static final Stroke WAVE_FOCUS_STROKE = new BasicStroke(2.0f);
    private static final Stroke WAVE_DIMMED_STROKE = new BasicStroke(0.5f);
    private static final Color WAVE_DIMMED_COLOR = Color.GRAY;
    private static final double[] PIXELS_PER_POINT = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private FourierSeries _fourierSeries;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private DiscreteHarmonicsChart _chartGraphic;
    private ArrayList _harmonicPlots;

    public GameHarmonicsView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, GameHarmonicsView.BACKGROUND_SIZE.width, GameHarmonicsView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this.addGraphic(this._backgroundGraphic, 1.0);
        this._backgroundGraphic.setLocation(0, 0);
        String string = FourierResources.getString("GameHarmonicsView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(TITLE_LOCATION);
        this.addGraphic(this._titleGraphic, 2.0);
        this._chartGraphic = new DiscreteHarmonicsChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(this._chartGraphic, 3.0);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(60, 50);
        this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        this._harmonicPlots = new ArrayList();
        for (int i = this._fourierSeries.getNumberOfHarmonics() - 1; i >= 0; --i) {
            HarmonicPlot harmonicPlot = new HarmonicPlot(component, this._chartGraphic);
            harmonicPlot.setHarmonic(this._fourierSeries.getHarmonic(i));
            harmonicPlot.setPeriod(1.0 / (double)(i + 1));
            harmonicPlot.setPixelsPerPoint(PIXELS_PER_POINT[i]);
            harmonicPlot.setStroke(WAVE_NORMAL_STROKE);
            harmonicPlot.setBorderColor(HarmonicColors.getInstance().getColor(i));
            harmonicPlot.setStartX(0.0);
            this._harmonicPlots.add(harmonicPlot);
            this._chartGraphic.addDataSetGraphic(harmonicPlot);
        }
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 4.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._chartGraphic.setIgnoreMouse(true);
        this._minimizeButton.setCursorHand();
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, GameHarmonicsView.BACKGROUND_SIZE.width, n));
            this._chartGraphic.setChartSize(GameHarmonicsView.CHART_SIZE.width, n - 75);
            this._titleGraphic.setLocation(GameHarmonicsView.TITLE_LOCATION.x, n / 2);
            this.setBoundsDirty();
        }
    }

    public void focusGained(HarmonicFocusEvent harmonicFocusEvent) {
        for (int i = 0; i < this._harmonicPlots.size(); ++i) {
            HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
            if (harmonicPlot.getHarmonic() != harmonicFocusEvent.getHarmonic()) {
                harmonicPlot.setBorderColor(WAVE_DIMMED_COLOR);
                harmonicPlot.setStroke(WAVE_DIMMED_STROKE);
                continue;
            }
            Harmonic harmonic = harmonicPlot.getHarmonic();
            if (harmonic != null) {
                Color color = HarmonicColors.getInstance().getColor(harmonic);
                harmonicPlot.setBorderColor(color);
            }
            harmonicPlot.setStroke(WAVE_FOCUS_STROKE);
        }
    }

    public void focusLost(HarmonicFocusEvent harmonicFocusEvent) {
        for (int i = 0; i < this._harmonicPlots.size(); ++i) {
            HarmonicPlot harmonicPlot = (HarmonicPlot)this._harmonicPlots.get(i);
            Harmonic harmonic = harmonicPlot.getHarmonic();
            if (harmonic != null) {
                Color color = HarmonicColors.getInstance().getColor(harmonic);
                harmonicPlot.setBorderColor(color);
            }
            harmonicPlot.setStroke(WAVE_NORMAL_STROKE);
        }
    }
}

