/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.discrete;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.WaveType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.text.MessageFormat;

public class DiscreteSumEquation
extends CompositePhetGraphic {
    private static final Color EQUATION_COLOR = Color.BLACK;
    private static final Font LHS_FONT;
    private static final Font RHS_FONT;
    private static final Font SUMMATION_SYMBOL_FONT;
    private static final Font SUMMATION_RANGE_FONT;
    private HTMLGraphic _lhsGraphic;
    private HTMLGraphic _rhsGraphic;
    private CompositePhetGraphic _summationGraphic;
    private PhetTextGraphic _upperRangeGraphic;

    public DiscreteSumEquation(Component component) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._lhsGraphic = new HTMLGraphic(component, LHS_FONT, "", EQUATION_COLOR);
        this.addGraphic(this._lhsGraphic);
        this._rhsGraphic = new HTMLGraphic(component, RHS_FONT, "", EQUATION_COLOR);
        this.addGraphic(this._rhsGraphic);
        this._summationGraphic = new CompositePhetGraphic(component);
        this.addGraphic(this._summationGraphic);
        String string = "<html>" + MathStrings.C_SIGMA + "</html>";
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, SUMMATION_SYMBOL_FONT, string, EQUATION_COLOR);
        hTMLGraphic.setLocation(0, 0);
        this._summationGraphic.addGraphic(hTMLGraphic);
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, SUMMATION_RANGE_FONT, "n = 1", EQUATION_COLOR);
        int n = hTMLGraphic.getX();
        int n2 = hTMLGraphic.getY() + hTMLGraphic.getHeight();
        phetTextGraphic.setLocation(n, n2);
        this._summationGraphic.addGraphic(phetTextGraphic);
        this._upperRangeGraphic = new PhetTextGraphic(component, SUMMATION_RANGE_FONT, "", EQUATION_COLOR);
        int n3 = hTMLGraphic.getX() + hTMLGraphic.getWidth() + 2;
        n = hTMLGraphic.getY() + 5;
        this._upperRangeGraphic.setLocation(n3, n);
        this._summationGraphic.addGraphic(this._upperRangeGraphic);
        this.setForm(Domain.SPACE, MathForm.WAVE_NUMBER, 1, WaveType.SINES);
    }

    public void setForm(Domain domain, MathForm mathForm, int n, WaveType waveType) {
        String string = MathStrings.getFunction(domain);
        String string2 = MathStrings.getTerm(domain, mathForm, waveType);
        String string3 = MathStrings.getCoefficient();
        Object[] objectArray = new Object[]{string3, "n"};
        String string4 = MessageFormat.format(string2, objectArray);
        this._lhsGraphic.setHTML("<html>" + string + " = </html>");
        this._rhsGraphic.setHTML("<html>" + string4 + "</html>");
        if (n < Integer.MAX_VALUE) {
            this._upperRangeGraphic.setText(String.valueOf(n));
        } else {
            this._upperRangeGraphic.setText(String.valueOf(MathStrings.C_INFINITY));
        }
        int n2 = 0;
        int n3 = 0;
        this._lhsGraphic.setLocation(n2, n3);
        n2 = this._lhsGraphic.getX() + this._lhsGraphic.getWidth() + 5;
        n3 = -5;
        this._summationGraphic.setLocation(n2, n3);
        n2 = this._summationGraphic.getX() + this._summationGraphic.getWidth() + 6;
        n3 = 0;
        this._rhsGraphic.setLocation(n2, n3);
    }

    static {
        RHS_FONT = LHS_FONT = new PhetFont(0, 20);
        SUMMATION_SYMBOL_FONT = new PhetFont(0, 30);
        SUMMATION_RANGE_FONT = new PhetFont(0, 12);
    }
}

