/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control.sliders;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.fourier.control.FourierAbstractControlPanel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractFourierSlider
extends JPanel
implements ChangeListener {
    private JSlider _slider;
    private JLabel _label;
    private String _format;
    private EventListenerList _listenerList;

    public AbstractFourierSlider(String string) {
        assert (string != null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this._format = string;
        this._listenerList = new EventListenerList();
        this._slider = new JSlider();
        this._slider.setValue(0);
        this._slider.addChangeListener(this);
        this._label = new JLabel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        easyGridBagLayout.setInsets(FourierAbstractControlPanel.DEFAULT_INSETS);
        this.setLayout(easyGridBagLayout);
        easyGridBagLayout.addAnchoredComponent(this._label, 0, 0, 17);
        easyGridBagLayout.addAnchoredComponent(this._slider, 1, 0, 17);
        this.updateLabel();
    }

    public abstract void setValue(double var1);

    public abstract double getValue();

    public JSlider getSlider() {
        return this._slider;
    }

    protected JLabel getLabel() {
        return this._label;
    }

    public void setFormat(String string) {
        assert (string != null);
        this._format = string;
        this.updateLabel();
    }

    protected String getFormat() {
        return this._format;
    }

    public boolean isAdjusting() {
        return this._slider.getValueIsAdjusting();
    }

    protected abstract void updateLabel();

    public void stateChanged(ChangeEvent changeEvent) {
        this.updateLabel();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

