/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.control.ExpandSumDialog;
import edu.colorado.phet.fourier.control.FourierAbstractControlPanel;
import edu.colorado.phet.fourier.control.FourierComboBox;
import edu.colorado.phet.fourier.control.FourierTitledPanel;
import edu.colorado.phet.fourier.control.sliders.AbstractFourierSlider;
import edu.colorado.phet.fourier.control.sliders.DefaultFourierSlider;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.event.SoundErrorEvent;
import edu.colorado.phet.fourier.event.SoundErrorListener;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.sound.FourierSoundPlayer;
import edu.colorado.phet.fourier.view.AmplitudeSlider;
import edu.colorado.phet.fourier.view.AnimationCycleController;
import edu.colorado.phet.fourier.view.discrete.DiscreteHarmonicsView;
import edu.colorado.phet.fourier.view.discrete.DiscreteSumView;
import edu.colorado.phet.fourier.view.tools.HarmonicPeriodDisplay;
import edu.colorado.phet.fourier.view.tools.HarmonicPeriodTool;
import edu.colorado.phet.fourier.view.tools.HarmonicWavelengthTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DiscreteControlPanel
extends FourierAbstractControlPanel
implements SoundErrorListener,
ChangeListener {
    private FourierSeries _fourierSeries;
    private DiscreteHarmonicsView _harmonicsView;
    private DiscreteSumView _sumView;
    private HarmonicWavelengthTool _wavelengthTool;
    private HarmonicPeriodTool _periodTool;
    private HarmonicPeriodDisplay _periodDisplay;
    private AnimationCycleController _animationCycleController;
    private FourierSoundPlayer _soundPlayer;
    private FourierComboBox _domainComboBox;
    private FourierComboBox _presetsComboBox;
    private JCheckBox _showInfiniteCheckBox;
    private JCheckBox _wavelengthToolCheckBox;
    private JComboBox _wavelengthToolComboBox;
    private JCheckBox _periodToolCheckBox;
    private JComboBox _periodToolComboBox;
    private JRadioButton _sinesRadioButton;
    private JRadioButton _cosinesRadioButton;
    private AbstractFourierSlider _numberOfHarmonicsSlider;
    private JCheckBox _showMathCheckBox;
    private FourierComboBox _mathFormComboBox;
    private JCheckBox _expandSumCheckBox;
    private JCheckBox _soundCheckBox;
    private JSlider _soundSlider;
    private ExpandSumDialog _expandSumDialog;
    private ArrayList _domainChoices;
    private ArrayList _presetChoices;
    private ArrayList _showWavelengthChoices;
    private ArrayList _showPeriodChoices;
    private ArrayList _spaceMathFormChoices;
    private ArrayList _timeMathFormChoices;
    private ArrayList _spaceAndTimeMathFormChoices;
    private MathForm _mathFormKeySpace;
    private MathForm _mathFormKeyTime;
    private MathForm _mathFormKeySpaceAndTime;
    private EventListener _eventListener;

    public DiscreteControlPanel(FourierAbstractModule fourierAbstractModule, FourierSeries fourierSeries, DiscreteHarmonicsView discreteHarmonicsView, DiscreteSumView discreteSumView, HarmonicWavelengthTool harmonicWavelengthTool, HarmonicPeriodTool harmonicPeriodTool, HarmonicPeriodDisplay harmonicPeriodDisplay, AnimationCycleController animationCycleController) {
        super(fourierAbstractModule);
        assert (fourierSeries != null);
        assert (discreteHarmonicsView != null);
        assert (discreteSumView != null);
        assert (harmonicWavelengthTool != null);
        assert (harmonicPeriodTool != null);
        assert (harmonicPeriodDisplay != null);
        assert (animationCycleController != null);
        this._fourierSeries = fourierSeries;
        this._harmonicsView = discreteHarmonicsView;
        this._sumView = discreteSumView;
        this._wavelengthTool = harmonicWavelengthTool;
        this._periodTool = harmonicPeriodTool;
        this._periodDisplay = harmonicPeriodDisplay;
        this._animationCycleController = animationCycleController;
        int n = FourierResources.getInt("DiscreteControlPanel.width", 275);
        this.setMinimumWidth(n);
        FourierTitledPanel fourierTitledPanel = new FourierTitledPanel(FourierResources.getString("DiscreteControlPanel.presetControls"));
        Object object = FourierResources.getString("DiscreteControlPanel.presets");
        this._presetChoices = new ArrayList();
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SINE_COSINE, FourierResources.getString("preset.sinecosine")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.TRIANGLE, FourierResources.getString("preset.triangle")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SQUARE, FourierResources.getString("preset.square")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.SAWTOOTH, FourierResources.getString("preset.sawtooth")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.WAVE_PACKET, FourierResources.getString("preset.wavePacket")));
        this._presetChoices.add(new FourierComboBox.Choice(Preset.CUSTOM, FourierResources.getString("preset.custom")));
        this._presetsComboBox = new FourierComboBox((String)object, this._presetChoices);
        object = FourierResources.getString("DiscreteControlPanel.numberOfHarmonics");
        this._numberOfHarmonicsSlider = new DefaultFourierSlider((String)object);
        this._numberOfHarmonicsSlider.getSlider().setMaximum(11);
        this._numberOfHarmonicsSlider.getSlider().setMinimum(1);
        this._numberOfHarmonicsSlider.getSlider().setMajorTickSpacing(2);
        this._numberOfHarmonicsSlider.getSlider().setMinorTickSpacing(1);
        this._numberOfHarmonicsSlider.getSlider().setSnapToTicks(true);
        this._numberOfHarmonicsSlider.getSlider().setPaintLabels(true);
        this._numberOfHarmonicsSlider.getSlider().setPaintTicks(true);
        this._showInfiniteCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.showInfinite"));
        object = new JPanel();
        Object object2 = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout((LayoutManager)object2);
        ((EasyGridBagLayout)object2).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)object2).setAnchor(17);
        ((EasyGridBagLayout)object2).setMinimumWidth(0, 25);
        int n2 = 0;
        int n3 = 1;
        ((EasyGridBagLayout)object2).addComponent(this._presetsComboBox, n2++, n3);
        ((EasyGridBagLayout)object2).addComponent(this._numberOfHarmonicsSlider, n2++, n3);
        ((EasyGridBagLayout)object2).addComponent(this._showInfiniteCheckBox, n2++, n3);
        fourierTitledPanel.setLayout(new BorderLayout());
        fourierTitledPanel.add((Component)object, "West");
        object = new FourierTitledPanel(FourierResources.getString("DiscreteControlPanel.graphControls"));
        object2 = FourierResources.getString("DiscreteControlPanel.domain");
        this._domainChoices = new ArrayList();
        this._domainChoices.add(new FourierComboBox.Choice(Domain.SPACE, FourierResources.getString("domain.space")));
        this._domainChoices.add(new FourierComboBox.Choice(Domain.TIME, FourierResources.getString("domain.time")));
        this._domainChoices.add(new FourierComboBox.Choice(Domain.SPACE_AND_TIME, FourierResources.getString("domain.spaceAndTime")));
        this._domainComboBox = new FourierComboBox((String)object2, this._domainChoices);
        object2 = new JPanel();
        this._sinesRadioButton = new JRadioButton(FourierResources.getString("waveType.sines"));
        this._cosinesRadioButton = new JRadioButton(FourierResources.getString("waveType.cosines"));
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._sinesRadioButton);
        ((ButtonGroup)serializable).add(this._cosinesRadioButton);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object2);
        ((Container)object2).setLayout(easyGridBagLayout);
        easyGridBagLayout.setInsets(DEFAULT_INSETS);
        easyGridBagLayout.addComponent(this._sinesRadioButton, 0, 0);
        easyGridBagLayout.addComponent(this._cosinesRadioButton, 0, 1);
        serializable = new JPanel();
        easyGridBagLayout = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout(easyGridBagLayout);
        easyGridBagLayout.setInsets(DEFAULT_INSETS);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setMinimumWidth(0, 25);
        int n4 = 0;
        int n5 = 1;
        easyGridBagLayout.addComponent(this._domainComboBox, n4++, n5);
        easyGridBagLayout.addComponent((Component)object2, n4++, n5);
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)serializable, "West");
        object2 = new FourierTitledPanel(FourierResources.getString("DiscreteControlPanel.toolControls"));
        serializable = new JPanel();
        this._wavelengthToolCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.wavelengthTool"));
        this._wavelengthToolComboBox = new JComboBox();
        this._showWavelengthChoices = new ArrayList();
        char c = MathStrings.C_WAVELENGTH;
        for (n4 = 0; n4 < 11; ++n4) {
            String string = "<html>" + c + "<sub>" + (n4 + 1) + "</sub></html>";
            this._showWavelengthChoices.add(string);
        }
        EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout(easyGridBagLayout2);
        easyGridBagLayout2.setInsets(DEFAULT_INSETS);
        easyGridBagLayout2.addAnchoredComponent(this._wavelengthToolCheckBox, 0, 0, 13);
        easyGridBagLayout2.addAnchoredComponent(this._wavelengthToolComboBox, 0, 1, 17);
        JPanel jPanel = new JPanel();
        this._periodToolCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.periodTool"));
        this._periodToolComboBox = new JComboBox();
        this._showPeriodChoices = new ArrayList();
        char c2 = MathStrings.C_PERIOD;
        for (n5 = 0; n5 < 11; ++n5) {
            String string = "<html>" + c2 + "<sub>" + (n5 + 1) + "</sub></html>";
            this._showPeriodChoices.add(string);
        }
        EasyGridBagLayout easyGridBagLayout3 = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout3);
        easyGridBagLayout3.setInsets(DEFAULT_INSETS);
        easyGridBagLayout3.setMinimumWidth(0, (int)this._wavelengthToolCheckBox.getPreferredSize().getWidth() + 2);
        easyGridBagLayout3.addAnchoredComponent(this._periodToolCheckBox, 0, 0, 17);
        easyGridBagLayout3.addAnchoredComponent(this._periodToolComboBox, 0, 1, 17);
        Serializable serializable2 = new JPanel();
        easyGridBagLayout3 = new EasyGridBagLayout((JPanel)serializable2);
        ((Container)serializable2).setLayout(easyGridBagLayout3);
        easyGridBagLayout3.setInsets(DEFAULT_INSETS);
        easyGridBagLayout3.setAnchor(17);
        easyGridBagLayout3.setMinimumWidth(0, 25);
        int n6 = 0;
        int n7 = 1;
        easyGridBagLayout3.addComponent((Component)serializable, n6++, n7);
        easyGridBagLayout3.addComponent(jPanel, n6++, n7);
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)serializable2, "West");
        serializable = new FourierTitledPanel(FourierResources.getString("DiscreteControlPanel.mathMode"));
        this._showMathCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.showMath"));
        this._spaceMathFormChoices = new ArrayList();
        this._spaceMathFormChoices.add(new FourierComboBox.Choice(MathForm.WAVELENGTH, FourierResources.getString("mathForm.wavelength")));
        this._spaceMathFormChoices.add(new FourierComboBox.Choice(MathForm.WAVE_NUMBER, FourierResources.getString("mathForm.waveNumber")));
        this._spaceMathFormChoices.add(new FourierComboBox.Choice(MathForm.MODE, FourierResources.getString("mathForm.mode")));
        this._timeMathFormChoices = new ArrayList();
        this._timeMathFormChoices.add(new FourierComboBox.Choice(MathForm.FREQUENCY, FourierResources.getString("mathForm.frequency")));
        this._timeMathFormChoices.add(new FourierComboBox.Choice(MathForm.PERIOD, FourierResources.getString("mathForm.period")));
        this._timeMathFormChoices.add(new FourierComboBox.Choice(MathForm.ANGULAR_FREQUENCY, FourierResources.getString("mathForm.angularFrequency")));
        this._timeMathFormChoices.add(new FourierComboBox.Choice(MathForm.MODE, FourierResources.getString("mathForm.mode")));
        this._spaceAndTimeMathFormChoices = new ArrayList();
        this._spaceAndTimeMathFormChoices.add(new FourierComboBox.Choice(MathForm.WAVELENGTH_AND_PERIOD, FourierResources.getString("mathForm.wavelengthAndPeriod")));
        this._spaceAndTimeMathFormChoices.add(new FourierComboBox.Choice(MathForm.WAVE_NUMBER_AND_ANGULAR_FREQUENCY, FourierResources.getString("mathForm.waveNumberAndAngularFrequency")));
        this._spaceAndTimeMathFormChoices.add(new FourierComboBox.Choice(MathForm.MODE, FourierResources.getString("mathForm.mode")));
        this._mathFormComboBox = new FourierComboBox("", this._spaceMathFormChoices);
        this._expandSumCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.expandSum"));
        jPanel = new JPanel();
        serializable2 = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        ((EasyGridBagLayout)serializable2).setMinimumWidth(0, 10);
        int n8 = 0;
        n6 = 1;
        ((EasyGridBagLayout)serializable2).addComponent(this._showMathCheckBox, n8++, n6);
        ((EasyGridBagLayout)serializable2).addComponent(this._mathFormComboBox, n8++, n6);
        ((EasyGridBagLayout)serializable2).addComponent(this._expandSumCheckBox, n8++, n6);
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add(jPanel, "West");
        jPanel = new FourierTitledPanel(FourierResources.getString("DiscreteControlPanel.audioControls"));
        this._soundCheckBox = new JCheckBox(FourierResources.getString("DiscreteControlPanel.sound"));
        serializable2 = new ImageIcon(FourierConstants.SOUND_MIN_IMAGE);
        JLabel jLabel = new JLabel((Icon)((Object)serializable2));
        ImageIcon imageIcon = new ImageIcon(FourierConstants.SOUND_MAX_IMAGE);
        JLabel jLabel2 = new JLabel(imageIcon);
        this._soundSlider = new JSlider();
        this._soundSlider.setMaximum(100);
        this._soundSlider.setMinimum(0);
        this._soundSlider.setValue(50);
        this._soundSlider.setPreferredSize(new Dimension(125, this._soundSlider.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        EasyGridBagLayout easyGridBagLayout4 = new EasyGridBagLayout(jPanel2);
        jPanel2.setLayout(easyGridBagLayout4);
        easyGridBagLayout4.setInsets(DEFAULT_INSETS);
        easyGridBagLayout4.setAnchor(17);
        easyGridBagLayout4.setMinimumWidth(1, 10);
        easyGridBagLayout4.addComponent(this._soundCheckBox, 0, 0);
        easyGridBagLayout4.addComponent(jLabel, 0, 2);
        easyGridBagLayout4.addComponent(this._soundSlider, 0, 3);
        easyGridBagLayout4.addComponent(jLabel2, 0, 4);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        this.addControlFullWidth(fourierTitledPanel);
        this.addVerticalSpace(10);
        this.addControlFullWidth((Component)object);
        this.addVerticalSpace(10);
        this.addControlFullWidth((Component)object2);
        this.addVerticalSpace(10);
        this.addControlFullWidth((Component)serializable);
        this.addVerticalSpace(10);
        this.addControlFullWidth(jPanel);
        serializable2 = PhetApplication.getInstance().getPhetFrame();
        this._expandSumDialog = new ExpandSumDialog((Frame)serializable2, this._fourierSeries);
        this.reset();
        this._eventListener = new EventListener();
        this._expandSumDialog.addWindowListener(this._eventListener);
        this._showInfiniteCheckBox.addActionListener(this._eventListener);
        this._wavelengthToolCheckBox.addActionListener(this._eventListener);
        this._periodToolCheckBox.addActionListener(this._eventListener);
        this._showMathCheckBox.addActionListener(this._eventListener);
        this._expandSumCheckBox.addActionListener(this._eventListener);
        this._expandSumDialog.getCloseButton().addActionListener(this._eventListener);
        this._soundCheckBox.addActionListener(this._eventListener);
        this._sinesRadioButton.addActionListener(this._eventListener);
        this._cosinesRadioButton.addActionListener(this._eventListener);
        this._numberOfHarmonicsSlider.addChangeListener(this._eventListener);
        this._soundSlider.addChangeListener(this._eventListener);
        this._domainComboBox.addItemListener(this._eventListener);
        this._presetsComboBox.addItemListener(this._eventListener);
        this._wavelengthToolComboBox.addItemListener(this._eventListener);
        this._periodToolComboBox.addItemListener(this._eventListener);
        this._mathFormComboBox.addItemListener(this._eventListener);
    }

    public void setPreset(Preset preset) {
        this._presetsComboBox.setSelectedKey(preset);
        this.handlePreset();
    }

    public Preset getPreset() {
        return (Preset)this._presetsComboBox.getSelectedKey();
    }

    public void setNumberOfHarmonics(int n) {
        this._numberOfHarmonicsSlider.setValue(n);
        this.handleNumberOfHarmonics();
    }

    public void setShowInfiniteEnabled(boolean bl) {
        this._showInfiniteCheckBox.setSelected(bl);
        this.handleShowInfinite();
    }

    public boolean isShowInfiniteEnabled() {
        return this._showInfiniteCheckBox.isSelected();
    }

    public void setDomain(Domain domain) {
        this._domainComboBox.setSelectedKey(domain);
        this.handleDomain();
    }

    public Domain getDomain() {
        return (Domain)this._domainComboBox.getSelectedKey();
    }

    public void setWaveType(WaveType waveType) {
        if (waveType == WaveType.SINES) {
            this._sinesRadioButton.setSelected(true);
        } else {
            this._cosinesRadioButton.setSelected(true);
        }
        this.handleWaveType();
    }

    public WaveType getWaveType() {
        WaveType waveType = null;
        waveType = this._sinesRadioButton.isSelected() ? WaveType.SINES : WaveType.COSINES;
        return waveType;
    }

    public void setWavelengthToolEnabled(boolean bl) {
        this._wavelengthToolCheckBox.setSelected(bl);
        this.handleWavelengthTool();
    }

    public boolean isWavelengthToolEnabled() {
        return this._wavelengthToolCheckBox.isSelected();
    }

    public void setPeriodToolEnabled(boolean bl) {
        this._periodToolCheckBox.setSelected(bl);
        this.handlePeriodTool();
    }

    public boolean isPeriodToolEnabled() {
        return this._periodToolCheckBox.isSelected();
    }

    public void setShowMathEnabled(boolean bl) {
        this._showMathCheckBox.setSelected(bl);
        this.handleShowMath();
    }

    public boolean isShowMathEnabled() {
        return this._showMathCheckBox.isSelected();
    }

    public void setMathForm(MathForm mathForm) {
        this._mathFormComboBox.setSelectedKey(mathForm);
        this.handleMathForm();
    }

    public MathForm getMathForm() {
        return (MathForm)this._mathFormComboBox.getSelectedKey();
    }

    public void setExpandSumEnabled(boolean bl) {
        this._expandSumCheckBox.setSelected(bl);
        this.handleExpandSum();
    }

    public boolean isExpandSumEnabled() {
        return this._expandSumCheckBox.isSelected();
    }

    public void setSoundEnabled(boolean bl) {
        this._soundCheckBox.removeActionListener(this._eventListener);
        this._soundCheckBox.setSelected(bl);
        this._soundCheckBox.addActionListener(this._eventListener);
        this.handleSoundOnOff(false);
    }

    public boolean isSoundEnabled() {
        return this._soundCheckBox.isSelected();
    }

    public void setSoundVolume(float f) {
        this._soundSlider.setValue((int)(f * 100.0f));
        this.handleSoundVolume();
    }

    public float getSoundVolume() {
        return (float)this._soundSlider.getValue() / 100.0f;
    }

    public void reset() {
        int n;
        this._domainComboBox.setSelectedKey(Domain.SPACE);
        this._animationCycleController.setEnabled(false);
        Preset preset = this._fourierSeries.getPreset();
        this._presetsComboBox.setSelectedKey(preset);
        this._showInfiniteCheckBox.setEnabled(true);
        this._showInfiniteCheckBox.setForeground(Color.BLACK);
        this._showInfiniteCheckBox.setSelected(false);
        this._sumView.setPresetEnabled(this._showInfiniteCheckBox.isSelected());
        this._wavelengthToolCheckBox.setSelected(false);
        this._wavelengthToolCheckBox.setEnabled(this._domainComboBox.getSelectedKey() == Domain.SPACE || this._domainComboBox.getSelectedKey() == Domain.SPACE_AND_TIME);
        this._wavelengthToolComboBox.setEnabled(this._wavelengthToolCheckBox.isSelected());
        this._wavelengthToolComboBox.removeAllItems();
        for (n = 0; n < this._fourierSeries.getNumberOfHarmonics(); ++n) {
            this._wavelengthToolComboBox.addItem(this._showWavelengthChoices.get(n));
        }
        this._wavelengthToolComboBox.setSelectedIndex(0);
        this._wavelengthTool.setVisible(this._wavelengthToolCheckBox.isSelected());
        this._periodToolCheckBox.setSelected(false);
        this._periodToolCheckBox.setEnabled(this._domainComboBox.getSelectedKey() == Domain.TIME || this._domainComboBox.getSelectedKey() == Domain.SPACE_AND_TIME);
        this._periodToolComboBox.setEnabled(this._periodToolCheckBox.isSelected());
        this._periodToolComboBox.removeAllItems();
        for (n = 0; n < this._fourierSeries.getNumberOfHarmonics(); ++n) {
            this._periodToolComboBox.addItem(this._showPeriodChoices.get(n));
        }
        this._periodToolComboBox.setSelectedIndex(0);
        this._periodTool.setVisible(this._periodToolCheckBox.isSelected());
        WaveType waveType = this._fourierSeries.getWaveType();
        this._sinesRadioButton.setSelected(waveType == WaveType.SINES);
        this._numberOfHarmonicsSlider.setValue(this._fourierSeries.getNumberOfHarmonics());
        this._showMathCheckBox.setSelected(false);
        this._mathFormComboBox.setEnabled(this._showMathCheckBox.isSelected());
        this._mathFormKeySpace = MathForm.WAVELENGTH;
        this._mathFormKeyTime = MathForm.FREQUENCY;
        this._mathFormKeySpaceAndTime = MathForm.WAVELENGTH_AND_PERIOD;
        if (this._domainComboBox.getSelectedKey() == Domain.SPACE) {
            this._mathFormComboBox.setChoices(this._spaceMathFormChoices);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeySpace);
        } else if (this._domainComboBox.getSelectedKey() == Domain.TIME) {
            this._mathFormComboBox.setChoices(this._timeMathFormChoices);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeyTime);
        } else {
            this._mathFormComboBox.setChoices(this._spaceAndTimeMathFormChoices);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeySpaceAndTime);
        }
        this._expandSumCheckBox.setEnabled(this._showMathCheckBox.isSelected());
        this._expandSumCheckBox.setSelected(false);
        this._expandSumDialog.hide();
        if (this._soundPlayer != null) {
            this._soundCheckBox.setSelected(false);
            this._soundPlayer.setSoundEnabled(this._soundCheckBox.isSelected());
            this._soundSlider.setValue((int)(this._soundPlayer.getVolume() * 100.0f));
        }
    }

    private void handleDomain() {
        Domain domain = (Domain)this._domainComboBox.getSelectedKey();
        if (domain == Domain.SPACE) {
            this._mathFormComboBox.removeItemListener(this._eventListener);
            this._mathFormComboBox.setChoices(this._spaceMathFormChoices);
            this._mathFormComboBox.addItemListener(this._eventListener);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeySpace);
            this._wavelengthToolCheckBox.setEnabled(true);
            this._wavelengthToolComboBox.setEnabled(this._wavelengthToolCheckBox.isSelected());
            this._wavelengthTool.setVisible(this._wavelengthToolCheckBox.isSelected());
            this._periodToolCheckBox.setEnabled(false);
            this._periodToolComboBox.setEnabled(false);
            this._periodTool.setVisible(false);
            this._periodDisplay.setVisible(false);
            this._animationCycleController.setEnabled(false);
        } else if (domain == Domain.TIME) {
            this._mathFormComboBox.removeItemListener(this._eventListener);
            this._mathFormComboBox.setChoices(this._timeMathFormChoices);
            this._mathFormComboBox.addItemListener(this._eventListener);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeyTime);
            this._wavelengthToolCheckBox.setEnabled(false);
            this._wavelengthToolComboBox.setEnabled(false);
            this._wavelengthTool.setVisible(false);
            this._periodToolCheckBox.setEnabled(true);
            this._periodToolComboBox.setEnabled(this._periodToolCheckBox.isSelected());
            this._periodTool.setVisible(this._periodToolCheckBox.isSelected());
            this._periodDisplay.setVisible(false);
            this._animationCycleController.setEnabled(false);
        } else if (domain == Domain.SPACE_AND_TIME) {
            this._mathFormComboBox.removeItemListener(this._eventListener);
            this._mathFormComboBox.setChoices(this._spaceAndTimeMathFormChoices);
            this._mathFormComboBox.addItemListener(this._eventListener);
            this._mathFormComboBox.setSelectedKey(this._mathFormKeySpaceAndTime);
            this._wavelengthToolCheckBox.setEnabled(true);
            this._wavelengthToolComboBox.setEnabled(this._wavelengthToolCheckBox.isSelected());
            this._wavelengthTool.setVisible(this._wavelengthToolCheckBox.isSelected());
            this._periodToolCheckBox.setEnabled(true);
            this._periodToolComboBox.setEnabled(this._periodToolCheckBox.isSelected());
            this._periodTool.setVisible(false);
            this._periodDisplay.setVisible(this._periodToolCheckBox.isSelected());
            this._animationCycleController.reset();
            this._animationCycleController.setEnabled(true);
        } else {
            throw new IllegalArgumentException("unsupported domain: " + domain);
        }
        MathForm mathForm = (MathForm)this._mathFormComboBox.getSelectedKey();
        this._sumView.setDomainAndMathForm(domain, mathForm);
        this._harmonicsView.setDomainAndMathForm(domain, mathForm);
        this._expandSumDialog.setDomainAndMathForm(domain, mathForm);
    }

    private void handlePreset() {
        this._animationCycleController.reset();
        Preset preset = (Preset)this._presetsComboBox.getSelectedKey();
        if (this._cosinesRadioButton.isSelected() && preset == Preset.SAWTOOTH) {
            this.showSawtoothCosinesErrorDialog();
            this._sinesRadioButton.setSelected(true);
            this._fourierSeries.setWaveType(WaveType.SINES);
        }
        boolean bl = preset != Preset.WAVE_PACKET && preset != Preset.CUSTOM;
        this._showInfiniteCheckBox.setEnabled(bl);
        this._showInfiniteCheckBox.setForeground(bl ? Color.BLACK : Color.GRAY);
        if (!bl) {
            this._showInfiniteCheckBox.setSelected(false);
            this._sumView.setPresetEnabled(false);
        }
        this._fourierSeries.setPreset(preset);
    }

    private void handleShowInfinite() {
        boolean bl = this._showInfiniteCheckBox.isSelected();
        this._sumView.setPresetEnabled(bl);
    }

    private void handleWavelengthTool() {
        this._wavelengthToolComboBox.setEnabled(this._wavelengthToolCheckBox.isEnabled() && this._wavelengthToolCheckBox.isSelected());
        this._wavelengthTool.setVisible(this._wavelengthToolCheckBox.isEnabled() && this._wavelengthToolCheckBox.isSelected());
        int n = this._wavelengthToolComboBox.getSelectedIndex();
        if (n >= 0) {
            Harmonic harmonic = this._fourierSeries.getHarmonic(n);
            this._wavelengthTool.setHarmonic(harmonic);
        }
    }

    private void handlePeriodTool() {
        this._periodToolComboBox.setEnabled(this._periodToolCheckBox.isEnabled() && this._periodToolCheckBox.isSelected());
        Domain domain = (Domain)this._domainComboBox.getSelectedKey();
        int n = this._periodToolComboBox.getSelectedIndex();
        if (domain == Domain.TIME) {
            this._periodTool.setVisible(this._periodToolCheckBox.isEnabled() && this._periodToolCheckBox.isSelected());
        } else if (domain == Domain.SPACE_AND_TIME) {
            this._periodDisplay.setVisible(this._periodToolCheckBox.isEnabled() && this._periodToolCheckBox.isSelected());
        }
        if (n >= 0) {
            Harmonic harmonic = this._fourierSeries.getHarmonic(n);
            this._periodTool.setHarmonic(harmonic);
            this._periodDisplay.setHarmonic(harmonic);
        }
    }

    private void handleWaveType() {
        this._animationCycleController.reset();
        Preset preset = (Preset)this._presetsComboBox.getSelectedKey();
        if (this._cosinesRadioButton.isSelected() && preset == Preset.SAWTOOTH) {
            this.showSawtoothCosinesErrorDialog();
            this._sinesRadioButton.setSelected(true);
            this._fourierSeries.setWaveType(WaveType.SINES);
        } else {
            WaveType waveType = this._sinesRadioButton.isSelected() ? WaveType.SINES : WaveType.COSINES;
            this._fourierSeries.setWaveType(waveType);
        }
    }

    private void handleNumberOfHarmonics() {
        int n;
        this.setWaitCursorEnabled(true);
        this._animationCycleController.reset();
        int n2 = (int)this._numberOfHarmonicsSlider.getValue();
        this._fourierSeries.setNumberOfHarmonics(n2);
        int n3 = this._wavelengthToolComboBox.getSelectedIndex();
        this._wavelengthToolComboBox.removeAllItems();
        for (n = 0; n < n2; ++n) {
            this._wavelengthToolComboBox.addItem(this._showWavelengthChoices.get(n));
        }
        if (n3 < n2) {
            this._wavelengthToolComboBox.setSelectedIndex(n3);
        } else {
            this._wavelengthToolCheckBox.setSelected(false);
            this._wavelengthTool.setVisible(false);
        }
        n3 = this._periodToolComboBox.getSelectedIndex();
        this._periodToolComboBox.removeAllItems();
        for (n = 0; n < n2; ++n) {
            this._periodToolComboBox.addItem(this._showPeriodChoices.get(n));
        }
        if (n3 < n2) {
            this._periodToolComboBox.setSelectedIndex(n3);
        } else {
            this._periodToolCheckBox.setSelected(false);
            this._periodTool.setVisible(false);
            this._periodDisplay.setVisible(false);
        }
        this.setWaitCursorEnabled(false);
    }

    private void handleShowMath() {
        boolean bl = this._showMathCheckBox.isSelected();
        this._mathFormComboBox.setEnabled(bl);
        this._expandSumCheckBox.setEnabled(bl);
        this._harmonicsView.setMathEnabled(bl);
        this._sumView.setMathEnabled(bl);
        if (!bl) {
            this._expandSumDialog.hide();
            this._expandSumCheckBox.setSelected(false);
        }
    }

    private void handleMathForm() {
        Domain domain = (Domain)this._domainComboBox.getSelectedKey();
        MathForm mathForm = (MathForm)this._mathFormComboBox.getSelectedKey();
        this._harmonicsView.setDomainAndMathForm(domain, mathForm);
        this._sumView.setDomainAndMathForm(domain, mathForm);
        this._expandSumDialog.setDomainAndMathForm(domain, mathForm);
        if (domain == Domain.SPACE) {
            this._mathFormKeySpace = mathForm;
        } else if (domain == Domain.TIME) {
            this._mathFormKeyTime = mathForm;
        } else {
            this._mathFormKeySpaceAndTime = mathForm;
        }
    }

    private void handleExpandSum() {
        if (this._expandSumCheckBox.isSelected()) {
            this._expandSumDialog.show();
        } else {
            this._expandSumDialog.hide();
        }
    }

    private void handleCloseExpandSumDialog() {
        this._expandSumDialog.hide();
        this._expandSumCheckBox.setSelected(false);
    }

    private void handleSoundOnOff(boolean bl) {
        if (this._soundCheckBox.isEnabled()) {
            if (this._soundPlayer == null && bl) {
                this.initializeSound();
            }
            if (this._soundPlayer != null) {
                this._soundPlayer.setSoundEnabled(this._soundCheckBox.isSelected());
            }
        }
    }

    private void handleSoundVolume() {
        if (this._soundPlayer != null) {
            this._soundPlayer.setVolume((float)this._soundSlider.getValue() / 100.0f);
        }
    }

    private void showSawtoothCosinesErrorDialog() {
        String string = FourierResources.getString("SawtoothCosinesErrorDialog.message");
        JOptionPane jOptionPane = new JOptionPane(string, 0, -1);
        jOptionPane.createDialog(this, null).show();
    }

    private void initializeSound() {
        if (this._soundPlayer == null) {
            try {
                this._soundPlayer = new FourierSoundPlayer(this._fourierSeries);
            }
            catch (Exception exception) {
                this._soundPlayer = null;
                this._soundCheckBox.setEnabled(false);
                this._soundSlider.setEnabled(false);
                String string = FourierResources.getString("sound.error.init");
                this.handleSoundError(string, exception);
            }
            this._soundPlayer.addSoundErrorListener(this);
        }
    }

    private void handleSoundError(String string, Exception exception) {
        PhetOptionPane.showErrorDialog(this, string);
        this._soundCheckBox.setSelected(false);
        this._soundCheckBox.setEnabled(false);
        if (this._soundPlayer != null) {
            this._soundPlayer.setSoundEnabled(false);
            this._soundPlayer.cleanup();
            this._soundPlayer = null;
        }
        exception.printStackTrace();
    }

    public void soundErrorOccurred(SoundErrorEvent soundErrorEvent) {
        this.handleSoundError(soundErrorEvent.getMessage(), soundErrorEvent.getException());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof AmplitudeSlider) {
            this._presetsComboBox.setSelectedKey(Preset.CUSTOM);
        }
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    ItemListener,
    ChangeListener {
        public void windowClosing(WindowEvent windowEvent) {
            if (windowEvent.getSource() == DiscreteControlPanel.this._expandSumDialog) {
                DiscreteControlPanel.this.handleCloseExpandSumDialog();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DiscreteControlPanel.this._showInfiniteCheckBox) {
                DiscreteControlPanel.this.handleShowInfinite();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._wavelengthToolCheckBox) {
                DiscreteControlPanel.this.handleWavelengthTool();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._periodToolCheckBox) {
                DiscreteControlPanel.this.handlePeriodTool();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._showMathCheckBox) {
                DiscreteControlPanel.this.handleShowMath();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._expandSumCheckBox) {
                DiscreteControlPanel.this.handleExpandSum();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._expandSumDialog.getCloseButton()) {
                DiscreteControlPanel.this.handleCloseExpandSumDialog();
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._soundCheckBox) {
                DiscreteControlPanel.this.handleSoundOnOff(true);
            } else if (actionEvent.getSource() == DiscreteControlPanel.this._sinesRadioButton || actionEvent.getSource() == DiscreteControlPanel.this._cosinesRadioButton) {
                DiscreteControlPanel.this.handleWaveType();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == DiscreteControlPanel.this._numberOfHarmonicsSlider) {
                if (!DiscreteControlPanel.this._numberOfHarmonicsSlider.isAdjusting()) {
                    DiscreteControlPanel.this.handleNumberOfHarmonics();
                }
            } else if (changeEvent.getSource() == DiscreteControlPanel.this._soundSlider) {
                DiscreteControlPanel.this.handleSoundVolume();
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == DiscreteControlPanel.this._domainComboBox.getComboBox()) {
                    DiscreteControlPanel.this.handleDomain();
                } else if (itemEvent.getSource() == DiscreteControlPanel.this._presetsComboBox.getComboBox()) {
                    DiscreteControlPanel.this.handlePreset();
                } else if (itemEvent.getSource() == DiscreteControlPanel.this._wavelengthToolComboBox) {
                    DiscreteControlPanel.this.handleWavelengthTool();
                } else if (itemEvent.getSource() == DiscreteControlPanel.this._periodToolComboBox) {
                    DiscreteControlPanel.this.handlePeriodTool();
                } else if (itemEvent.getSource() == DiscreteControlPanel.this._mathFormComboBox.getComboBox()) {
                    DiscreteControlPanel.this.handleMathForm();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }
    }
}

