/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

public class TrigCache {
    private double[] _sineValues;
    private double[] _cosineValues;

    public TrigCache(int n) {
        this.initCache(n);
    }

    private void initCache(int n) {
        double d = Math.PI * 2 / (double)n;
        this._sineValues = new double[n];
        this._cosineValues = new double[n];
        for (int i = 0; i < n; ++i) {
            this._sineValues[i] = Math.sin((double)i * d);
            this._cosineValues[i] = Math.cos((double)i * d);
        }
    }

    public double sin(double d) {
        double d2 = Math.PI * 2 / (double)this._sineValues.length;
        double d3 = Math.abs(d) % (Math.PI * 2);
        int n = (int)Math.round(d3 / d2);
        if (n > this._sineValues.length - 1) {
            n = 0;
        }
        double d4 = this._sineValues[n];
        if (d < 0.0) {
            d4 = -d4;
        }
        return d4;
    }

    public double cos(double d) {
        double d2 = Math.PI * 2 / (double)this._cosineValues.length;
        double d3 = Math.abs(d) % (Math.PI * 2);
        int n = (int)Math.round(d3 / d2);
        if (n > this._sineValues.length - 1) {
            n = 0;
        }
        double d4 = this._cosineValues[n];
        return d4;
    }
}

