/*
 * Decompiled with CFR 0.152.
 */
class FFT {
    double[] wtabf;
    double[] wtabi;
    int size;

    FFT(int n) {
        this.size = n;
        if ((this.size & this.size - 1) != 0) {
            System.out.println("size must be power of two!");
        }
        this.calcWTable();
    }

    void calcWTable() {
        this.wtabf = new double[this.size];
        this.wtabi = new double[this.size];
        for (int i = 0; i != this.size; i += 2) {
            double d = 3.1415926535;
            double d2 = d * (double)i / (double)this.size;
            this.wtabf[i] = Math.cos(d2);
            this.wtabf[i + 1] = Math.sin(d2);
            this.wtabi[i] = this.wtabf[i];
            this.wtabi[i + 1] = -this.wtabf[i + 1];
        }
    }

    void transform(double[] dArray, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        int n;
        int n2 = 0;
        int n3 = this.size * 2;
        if ((this.size & this.size - 1) != 0) {
            System.out.println("size must be power of two!");
        }
        for (n = 0; n != n3; n += 2) {
            if (n > n2) {
                double d5 = dArray[n];
                dArray[n] = dArray[n2];
                dArray[n2] = d5;
                d5 = dArray[n + 1];
                dArray[n + 1] = dArray[n2 + 1];
                dArray[n2 + 1] = d5;
            }
            int n4 = this.size;
            while ((n4 & n2) != 0) {
                n2 &= ~n4;
                n4 >>= 1;
            }
            n2 |= n4;
        }
        int n5 = this.size << 1;
        double[] dArray2 = bl ? this.wtabi : this.wtabf;
        for (n = 0; n != n3; n += 4) {
            d4 = dArray[n];
            d3 = dArray[n + 1];
            d2 = dArray[n + 2];
            d = dArray[n + 3];
            dArray[n] = d4 + d2;
            dArray[n + 1] = d3 + d;
            dArray[n + 2] = d4 - d2;
            dArray[n + 3] = d3 - d;
        }
        n5 >>= 1;
        int n6 = bl ? -1 : 1;
        for (n = 0; n != n3; n += 8) {
            d4 = dArray[n];
            d3 = dArray[n + 1];
            d2 = dArray[n + 4];
            d = dArray[n + 5];
            dArray[n] = d4 + d2;
            dArray[n + 1] = d3 + d;
            dArray[n + 4] = d4 - d2;
            dArray[n + 5] = d3 - d;
            d4 = dArray[n + 2];
            d3 = dArray[n + 3];
            d2 = dArray[n + 6] * (double)n6;
            d = dArray[n + 7] * (double)n6;
            dArray[n + 2] = d4 - d;
            dArray[n + 3] = d3 + d2;
            dArray[n + 6] = d4 + d;
            dArray[n + 7] = d3 - d2;
        }
        n5 >>= 1;
        for (int i = 16; i <= n3; i <<= 1) {
            int n7 = i >> 1;
            n5 >>= 1;
            for (n = 0; n != 1000; ++n) {
            }
            for (n = 0; n < n3; n += i) {
                int n8 = 0;
                n2 = n;
                while (n2 != n + n7) {
                    double d6 = dArray2[n8];
                    double d7 = dArray2[n8 + 1];
                    d4 = dArray[n2];
                    d3 = dArray[n2 + 1];
                    int n9 = n2 + n7;
                    d2 = dArray[n9];
                    d = dArray[n9 + 1];
                    double d8 = d2 * d6 - d * d7;
                    double d9 = d2 * d7 + d * d6;
                    dArray[n2] = d4 + d8;
                    dArray[n2 + 1] = d3 + d9;
                    dArray[n9] = d4 - d8;
                    dArray[n9 + 1] = d3 - d9;
                    n2 += 2;
                    n8 += n5;
                }
            }
        }
    }
}

