/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.view.tools.MeasurementTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Stroke;

public abstract class AbstractWavePacketMeasurementTool
extends MeasurementTool
implements Chart.Listener,
SimpleObserver {
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color LABEL_BACKGROUND_COLOR = new Color(255, 255, 255, 150);
    private static final Color BAR_FILL_COLOR = Color.YELLOW;
    private static final Color BAR_BORDER_COLOR = Color.BLACK;
    private static final Stroke BAR_STROKE = new BasicStroke(1.0f);
    private GaussianWavePacket _wavePacket;
    private Chart _chart;
    private Domain _domain;

    public AbstractWavePacketMeasurementTool(Component component, GaussianWavePacket gaussianWavePacket, Chart chart) {
        super(component);
        assert (gaussianWavePacket != null);
        this._wavePacket = gaussianWavePacket;
        this._wavePacket.addObserver(this);
        assert (chart != null);
        this._chart = chart;
        this._chart.addListener(this);
        this.setLabelFont(LABEL_FONT);
        this.setLabelColor(LABEL_COLOR);
        this.setFillColor(BAR_FILL_COLOR);
        this.setBorderColor(BAR_BORDER_COLOR);
        this.setStroke(BAR_STROKE);
        this.setLabelBackground(LABEL_BACKGROUND_COLOR);
        this._domain = Domain.SPACE;
    }

    protected GaussianWavePacket getWavePacket() {
        return this._wavePacket;
    }

    protected Chart getChart() {
        return this._chart;
    }

    public void setDomain(Domain domain) {
        this._domain = domain;
        this.updateTool();
    }

    protected Domain getDomain() {
        return this._domain;
    }

    protected abstract void updateTool();

    public void update() {
        if (this.isVisible()) {
            this.updateTool();
        }
    }

    public void transformChanged(Chart chart) {
        this.updateTool();
    }
}

