/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.StringLabelTable;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.fourier.MathStrings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.text.DecimalFormat;

public class D2CAmplitudesChart
extends Chart {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(1.0f);
    private static final Font AXIS_TITLE_FONT = new PhetFont(1, 12);
    private static final Color AXIS_TITLE_COLOR = Color.BLACK;
    private static final Stroke X_MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Stroke X_MINOR_TICK_STROKE = new BasicStroke(0.5f);
    private static final Font X_MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Stroke Y_MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Stroke Y_MINOR_TICK_STROKE = new BasicStroke(0.5f);
    private static final Font Y_MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Color MAJOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MAJOR_GRIDLINE_STROKE = new BasicStroke(0.1f);
    private HTMLGraphic _xAxisTitleGraphic;

    public D2CAmplitudesChart(Component component, Range2D range2D, Dimension dimension) {
        super(component, range2D, dimension);
        this.getXAxis().setStroke(AXIS_STROKE);
        this.getXAxis().setColor(AXIS_COLOR);
        this._xAxisTitleGraphic = new HTMLGraphic(component, AXIS_TITLE_FONT, "", AXIS_TITLE_COLOR);
        this.setXAxisTitle(this._xAxisTitleGraphic);
        this.getXAxis().setMajorTicksVisible(false);
        this.getHorizontalTicks().setMajorTicksVisible(true);
        this.getHorizontalTicks().setMajorTickLabelsVisible(true);
        this.getHorizontalTicks().setMajorTickSpacing(Math.PI * 2);
        this.getHorizontalTicks().setMajorTickStroke(X_MAJOR_TICK_STROKE);
        this.getHorizontalTicks().setMajorTickFont(X_MAJOR_TICK_FONT);
        StringLabelTable stringLabelTable = new StringLabelTable(this.getComponent(), X_MAJOR_TICK_FONT, Color.BLACK);
        stringLabelTable.put(0.0, "0");
        stringLabelTable.put(Math.PI * 2, "2" + MathStrings.C_PI);
        stringLabelTable.put(Math.PI * 4, "4" + MathStrings.C_PI);
        stringLabelTable.put(Math.PI * 6, "6" + MathStrings.C_PI);
        stringLabelTable.put(Math.PI * 8, "8" + MathStrings.C_PI);
        stringLabelTable.put(Math.PI * 10, "10" + MathStrings.C_PI);
        stringLabelTable.put(37.69911184307752, "12" + MathStrings.C_PI);
        stringLabelTable.put(43.982297150257104, "14" + MathStrings.C_PI);
        stringLabelTable.put(50.26548245743669, "16" + MathStrings.C_PI);
        stringLabelTable.put(56.548667764616276, "18" + MathStrings.C_PI);
        stringLabelTable.put(62.83185307179586, "20" + MathStrings.C_PI);
        stringLabelTable.put(69.11503837897544, "22" + MathStrings.C_PI);
        stringLabelTable.put(75.39822368615503, "24" + MathStrings.C_PI);
        this.getHorizontalTicks().setMajorLabels(stringLabelTable);
        this.getXAxis().setMinorTicksVisible(false);
        this.getHorizontalTicks().setMinorTicksVisible(true);
        this.getHorizontalTicks().setMinorTickLabelsVisible(false);
        this.getHorizontalTicks().setMinorTickSpacing(1.5707963267948966);
        this.getHorizontalTicks().setMinorTickStroke(X_MINOR_TICK_STROKE);
        this.getVerticalGridlines().setMajorGridlinesVisible(false);
        this.getVerticalGridlines().setMinorGridlinesVisible(false);
        this.getYAxis().setStroke(AXIS_STROKE);
        this.getYAxis().setColor(AXIS_COLOR);
        this.getYAxis().setMajorTicksVisible(false);
        this.getVerticalTicks().setMajorTicksVisible(true);
        this.getVerticalTicks().setMajorTickLabelsVisible(true);
        this.getVerticalTicks().setMajorTickSpacing(0.2);
        this.getVerticalTicks().setMajorTickStroke(Y_MAJOR_TICK_STROKE);
        this.getVerticalTicks().setMajorTickFont(Y_MAJOR_TICK_FONT);
        this.getYAxis().setMinorTicksVisible(false);
        this.getVerticalTicks().setMinorTicksVisible(true);
        this.getVerticalTicks().setMinorTickLabelsVisible(false);
        this.getVerticalTicks().setMinorTickSpacing(0.1);
        this.getVerticalTicks().setMinorTickStroke(Y_MINOR_TICK_STROKE);
        this.getHorizonalGridlines().setMajorGridlinesVisible(true);
        this.getHorizonalGridlines().setMajorTickSpacing(0.2);
        this.getHorizonalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getHorizonalGridlines().setMinorGridlinesVisible(false);
    }

    public void setXAxisTitle(String string) {
        this._xAxisTitleGraphic.setHTML(string);
        this._xAxisTitleGraphic.setRegistrationPoint(-2, this._xAxisTitleGraphic.getHeight());
    }

    public void autoscaleY(double d) {
        DecimalFormat decimalFormat;
        double d2 = 0.0;
        double d3 = 0.0;
        if (d > 1.0) {
            d2 = 1.0;
            d3 = 0.5;
            decimalFormat = new DecimalFormat("#.#");
        } else if (d > 0.5) {
            d2 = 0.2;
            d3 = 0.1;
            decimalFormat = new DecimalFormat(".##");
        } else if (d > 0.2) {
            d2 = 0.1;
            d3 = 0.05;
            decimalFormat = new DecimalFormat(".##");
        } else if (d > 0.05) {
            d2 = 0.05;
            d3 = 0.01;
            decimalFormat = new DecimalFormat(".##");
        } else if (d > 0.02) {
            d2 = 0.01;
            d3 = 0.005;
            decimalFormat = new DecimalFormat(".###");
        } else {
            d2 = 0.005;
            d3 = 0.001;
            decimalFormat = new DecimalFormat(".###");
        }
        Range2D range2D = this.getRange();
        if (d > range2D.getMaxY()) {
            this.getVerticalTicks().setMajorNumberFormat(decimalFormat);
            this.getVerticalTicks().setMajorTickSpacing(d2);
            this.getVerticalTicks().setMinorTickSpacing(d3);
            this.getHorizonalGridlines().setMajorTickSpacing(d2);
            range2D.setMaxY(d);
            this.setRange(range2D);
        } else {
            range2D.setMaxY(d);
            this.setRange(range2D);
            this.getVerticalTicks().setMajorNumberFormat(decimalFormat);
            this.getVerticalTicks().setMajorTickSpacing(d2);
            this.getVerticalTicks().setMinorTickSpacing(d3);
            this.getHorizonalGridlines().setMajorTickSpacing(d2);
        }
    }
}

