/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view;

import edu.colorado.phet.fourier.event.HarmonicColorChangeEvent;
import edu.colorado.phet.fourier.event.HarmonicColorChangeListener;
import edu.colorado.phet.fourier.model.Harmonic;
import java.awt.Color;
import javax.swing.event.EventListenerList;

public class HarmonicColors {
    private static final HarmonicColors INSTANCE = new HarmonicColors();
    private Color[] _harmonicColors = new Color[]{new Color(1.0f, 0.0f, 0.0f), new Color(1.0f, 0.5f, 0.0f), new Color(1.0f, 1.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f), new Color(0.0f, 0.790002f, 0.340007f), new Color(0.392193f, 0.584307f, 0.929395f), new Color(0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.501999f), new Color(0.569994f, 0.129994f, 0.61999f), new Color(0.729408f, 0.333293f, 0.827494f), new Color(1.0f, 0.411802f, 0.705893f)};
    private EventListenerList _listenerList = new EventListenerList();

    public static HarmonicColors getInstance() {
        return INSTANCE;
    }

    private HarmonicColors() {
    }

    public int getNumberOfColors() {
        return this._harmonicColors.length;
    }

    public void setColor(int n, Color color) {
        assert (this.isManaged(n));
        this._harmonicColors[n] = color;
        this.fireChangeEvent(n, color);
    }

    public Color getColor(int n) {
        assert (this.isManaged(n));
        return this._harmonicColors[n];
    }

    public Color getColor(Harmonic harmonic) {
        return this.getColor(harmonic.getOrder());
    }

    private boolean isManaged(int n) {
        return n >= 0 && n < this._harmonicColors.length;
    }

    public void addHarmonicColorChangeListener(HarmonicColorChangeListener harmonicColorChangeListener) {
        this._listenerList.add(HarmonicColorChangeListener.class, harmonicColorChangeListener);
    }

    public void removeHarmonicColorChangeListener(HarmonicColorChangeListener harmonicColorChangeListener) {
        this._listenerList.remove(HarmonicColorChangeListener.class, harmonicColorChangeListener);
    }

    private void fireChangeEvent(int n, Color color) {
        HarmonicColorChangeEvent harmonicColorChangeEvent = new HarmonicColorChangeEvent(this, n, color);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != HarmonicColorChangeListener.class) continue;
            ((HarmonicColorChangeListener)objectArray[i + 1]).harmonicColorChanged(harmonicColorChangeEvent);
        }
    }
}

