/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.sound;

import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.event.SoundErrorEvent;
import edu.colorado.phet.fourier.event.SoundErrorListener;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.sound.FourierOscillator;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.event.EventListenerList;

public class FourierSoundPlayer
implements Runnable {
    private static final AudioFormat.Encoding ENCODING = AudioFormat.Encoding.PCM_SIGNED;
    private FourierOscillator _oscillator;
    private SourceDataLine _sourceDataLine;
    private boolean _soundEnabled = false;
    private EventListenerList _listenerList = new EventListenerList();

    public FourierSoundPlayer(FourierSeries fourierSeries) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(ENCODING, 44100.0f, 16, 2, 4, 44100.0f, false);
        this._oscillator = new FourierOscillator(fourierSeries, 0.5f, audioFormat, -1L);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this._sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
        this._sourceDataLine.open(audioFormat, 16000);
    }

    public void cleanup() {
        this._oscillator.cleanup();
        this._oscillator = null;
        this._listenerList = new EventListenerList();
    }

    public void setSoundEnabled(boolean bl) {
        this._soundEnabled = bl;
        if (bl) {
            Thread thread = new Thread(this);
            thread.start();
            this._sourceDataLine.start();
        } else {
            this._sourceDataLine.stop();
            this._sourceDataLine.flush();
        }
        this._oscillator.setEnabled(bl);
    }

    public void setVolume(float f) {
        this._oscillator.setVolume(f);
    }

    public float getVolume() {
        return this._oscillator.getVolume();
    }

    public void addSoundErrorListener(SoundErrorListener soundErrorListener) {
        this._listenerList.add(SoundErrorListener.class, soundErrorListener);
    }

    private void notifySoundErrorListeners(Exception exception, String string) {
        SoundErrorEvent soundErrorEvent = new SoundErrorEvent(this, exception, string);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != SoundErrorListener.class) continue;
            ((SoundErrorListener)objectArray[i + 1]).soundErrorOccurred(soundErrorEvent);
        }
    }

    public void run() {
        byte[] byArray = new byte[16000];
        while (this._soundEnabled) {
            try {
                int n = this._oscillator.read(byArray);
                int n2 = this._sourceDataLine.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                this._soundEnabled = false;
                String string = FourierResources.getString("sound.error.io");
                this.notifySoundErrorListeners(iOException, string);
            }
        }
    }
}

