/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;

public class GaussianWavePacket
extends SimpleObservable {
    private double _spacing;
    private double _width;
    private double _center;
    private double _significantWidth;

    public GaussianWavePacket(double d, double d2, double d3, double d4) {
        this._spacing = d;
        this._width = d2;
        this._center = d3;
        this._significantWidth = d4;
    }

    public void setSpacing(double d) {
        assert (d >= 0.0);
        if (d != this._spacing) {
            this._spacing = d;
            this.notifyObservers();
        }
    }

    public double getSpacing() {
        return this._spacing;
    }

    public void setWidth(double d) {
        assert (d > 0.0);
        if (d != this._width) {
            this._width = d;
            this.notifyObservers();
        }
    }

    public double getWidth() {
        return this._width;
    }

    public void setCenter(double d) {
        if (d != this._center) {
            this._center = d;
            this.notifyObservers();
        }
    }

    public double getCenter() {
        return this._center;
    }

    public int getNumberOfComponents() {
        if (this._spacing == 0.0) {
            return Integer.MAX_VALUE;
        }
        return (int)(this._significantWidth / this._spacing) - 1;
    }

    public void setSignificantWidth(double d) {
        if (d != this._significantWidth) {
            this._significantWidth = d;
            this.notifyObservers();
        }
    }

    public void setK1(double d) {
        this.setSpacing(d);
    }

    public double getK1() {
        return this.getSpacing();
    }

    public void setDeltaK(double d) {
        this.setWidth(2.0 * d);
    }

    public double getDeltaK() {
        return this.getWidth() / 2.0;
    }

    public void setDeltaX(double d) {
        this.setDeltaK(1.0 / d);
    }

    public double getDeltaX() {
        return 1.0 / this.getDeltaK();
    }

    public void setK0(double d) {
        this.setCenter(d);
    }

    public double getK0() {
        return this.getCenter();
    }

    public static double getAmplitude(double d, double d2, double d3) {
        return Math.exp(-Math.pow(d - d2, 2.0) / (2.0 * d3 * d3)) / (d3 * Math.sqrt(Math.PI * 2));
    }
}

