/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control.sliders;

import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.control.sliders.AbstractFourierSlider;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;

public class WavePacketSpacingSlider
extends AbstractFourierSlider {
    private static final double[] VALUES = new double[]{0.0, 0.7853981633974483, 1.5707963267948966, Math.PI, Math.PI * 2};
    private DecimalFormat _spacingFormatter;

    public WavePacketSpacingSlider() {
        super(FourierResources.getString("WavePacketSpacingSlider.format.space"));
        this.getSlider().setMinimum(0);
        this.getSlider().setMaximum(4);
        this.getSlider().setValue(0);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0"));
        hashtable.put(new Integer(1), new JLabel(MathStrings.C_PI + "/4"));
        hashtable.put(new Integer(2), new JLabel(MathStrings.C_PI + "/2"));
        hashtable.put(new Integer(3), new JLabel("" + MathStrings.C_PI));
        hashtable.put(new Integer(4), new JLabel("2" + MathStrings.C_PI));
        this.getSlider().setLabelTable(hashtable);
        this.getSlider().setPaintLabels(true);
        this.getSlider().setMajorTickSpacing(1);
        this.getSlider().setSnapToTicks(true);
        this.getSlider().setPaintTicks(true);
    }

    public void setValue(double d) {
        boolean bl = false;
        for (int i = 0; i < VALUES.length; ++i) {
            if (d != VALUES[i]) continue;
            this.getSlider().setValue(i);
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("illegal k1 spacing value: " + d);
        }
    }

    public double getValue() {
        int n = this.getSlider().getValue();
        return VALUES[n];
    }

    protected void updateLabel() {
        String string = this.getFormat();
        double d = this.getValue();
        if (this._spacingFormatter == null) {
            this._spacingFormatter = new DecimalFormat("#.##");
        }
        String string2 = this._spacingFormatter.format(d);
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        this.getLabel().setText(string3);
    }
}

