/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.view.HarmonicColors;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class HarmonicColorsDialog
extends PaintImmediateDialog
implements ColorChooserFactory.Listener {
    private static final Stroke COLOR_BAR_STROKE = new BasicStroke(1.0f);
    private static final Color COLOR_BAR_BORDER_COLOR = Color.BLACK;
    private PhetApplication _app;
    private JButton _okButton;
    private JButton _cancelButton;
    private Color[] _restoreColors;
    private JLabel[] _colorBars;
    private int _editIndex;

    public HarmonicColorsDialog(PhetApplication phetApplication) {
        super(phetApplication.getPhetFrame());
        this._app = phetApplication;
        super.setTitle(FourierResources.getString("HarmonicColorsDialog.title"));
        super.setModal(false);
        super.setResizable(false);
        this.createUI(phetApplication.getPhetFrame());
    }

    private void createUI(Frame frame) {
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private JPanel createInputPanel() {
        String string = FourierResources.getString("HarmonicColorsDialog.edit");
        BasicStroke basicStroke = new BasicStroke(1.0f);
        JPanel jPanel = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = HarmonicColors.getInstance().getNumberOfColors();
        this._restoreColors = new Color[n2];
        this._colorBars = new JLabel[n2];
        for (int i = 0; i < n2; ++i) {
            JLabel jLabel;
            Color color;
            JPanel jPanel2 = new JPanel();
            JLabel jLabel2 = new JLabel(String.valueOf(i + 1));
            this._restoreColors[i] = color = HarmonicColors.getInstance().getColor(i);
            this._colorBars[i] = jLabel = new JLabel();
            this.setColor(jLabel, color);
            jLabel.addMouseListener(new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    for (int i = 0; i < HarmonicColorsDialog.this._colorBars.length; ++i) {
                        if (mouseEvent.getSource() != HarmonicColorsDialog.this._colorBars[i]) continue;
                        HarmonicColorsDialog.this.editColor(i);
                    }
                }
            });
            EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout(jPanel2);
            jPanel2.setLayout(easyGridBagLayout2);
            int n3 = 0;
            easyGridBagLayout2.addAnchoredComponent(jLabel2, 0, n3++, 13);
            easyGridBagLayout2.addAnchoredComponent(jLabel, 0, n3++, 17);
            easyGridBagLayout.addAnchoredComponent(jPanel2, n++, 0, 13);
        }
        return jPanel;
    }

    private JPanel createActionsPanel() {
        this._okButton = new JButton(FourierResources.getString("HarmonicColorsDialog.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HarmonicColorsDialog.this.dispose();
            }
        });
        this._cancelButton = new JButton(FourierResources.getString("HarmonicColorsDialog.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HarmonicColorsDialog.this.restoreColors();
                HarmonicColorsDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void editColor(int n) {
        this._editIndex = n;
        Object[] objectArray = new Object[]{new Integer(n + 1)};
        String string = FourierResources.getString("HarmonicColors.colorChooser.title");
        String string2 = MessageFormat.format(string, objectArray);
        PhetFrame phetFrame = this._app.getPhetFrame();
        Color color = HarmonicColors.getInstance().getColor(n);
        JDialog jDialog = ColorChooserFactory.createDialog(string2, phetFrame, color, this);
        jDialog.show();
    }

    private void restoreColors() {
        int n = HarmonicColors.getInstance().getNumberOfColors();
        for (int i = 0; i < n; ++i) {
            if (HarmonicColors.getInstance().getColor(i).equals(this._restoreColors[i])) continue;
            HarmonicColors.getInstance().setColor(i, this._restoreColors[i]);
        }
    }

    private void setColor(JLabel jLabel, Color color) {
        Rectangle rectangle = new Rectangle(0, 0, 200, 20);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(COLOR_BAR_STROKE);
        graphics2D.setColor(COLOR_BAR_BORDER_COLOR);
        graphics2D.draw(rectangle);
        jLabel.setIcon(new ImageIcon(bufferedImage));
    }

    public void colorChanged(Color color) {
        this.handleColorChange(color);
    }

    public void ok(Color color) {
        this.handleColorChange(color);
    }

    public void cancelled(Color color) {
        this.handleColorChange(color);
    }

    private void handleColorChange(Color color) {
        this.setColor(this._colorBars[this._editIndex], color);
        HarmonicColors.getInstance().setColor(this._editIndex, color);
    }
}

