/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.FourierAbstractControlPanel;
import edu.colorado.phet.fourier.control.FourierComboBox;
import edu.colorado.phet.fourier.control.FourierTitledPanel;
import edu.colorado.phet.fourier.control.sliders.WavePacketCenterSlider;
import edu.colorado.phet.fourier.control.sliders.WavePacketKWidthSlider;
import edu.colorado.phet.fourier.control.sliders.WavePacketSpacingSlider;
import edu.colorado.phet.fourier.control.sliders.WavePacketXWidthSlider;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.view.d2c.D2CAmplitudesView;
import edu.colorado.phet.fourier.view.d2c.D2CComponentsView;
import edu.colorado.phet.fourier.view.d2c.D2CSumView;
import edu.colorado.phet.fourier.view.tools.WavePacketPeriodTool;
import edu.colorado.phet.fourier.view.tools.WavePacketSpacingTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class D2CControlPanel
extends FourierAbstractControlPanel {
    private GaussianWavePacket _wavePacket;
    private D2CAmplitudesView _amplitudesView;
    private D2CComponentsView _harmonicsView;
    private D2CSumView _sumView;
    private WavePacketSpacingTool _spacingTool;
    private WavePacketPeriodTool _periodTool;
    private FourierComboBox _domainComboBox;
    private WavePacketSpacingSlider _spacingSlider;
    private WavePacketCenterSlider _centerSlider;
    private JCheckBox _amplitudesEnvelopeCheckBox;
    private JCheckBox _sumEnvelopeCheckBox;
    private WavePacketKWidthSlider _kWidthSlider;
    private WavePacketXWidthSlider _xWidthSlider;
    private JRadioButton _sinesRadioButton;
    private JRadioButton _cosinesRadioButton;
    private JCheckBox _showWidthsCheckBox;
    private ArrayList _domainChoices;
    private EventListener _listener;

    public D2CControlPanel(FourierAbstractModule fourierAbstractModule, GaussianWavePacket gaussianWavePacket, D2CAmplitudesView d2CAmplitudesView, D2CComponentsView d2CComponentsView, D2CSumView d2CSumView, WavePacketSpacingTool wavePacketSpacingTool, WavePacketPeriodTool wavePacketPeriodTool) {
        super(fourierAbstractModule);
        assert (gaussianWavePacket != null);
        assert (d2CAmplitudesView != null);
        assert (d2CComponentsView != null);
        assert (d2CSumView != null);
        assert (wavePacketSpacingTool != null);
        assert (wavePacketPeriodTool != null);
        this._wavePacket = gaussianWavePacket;
        this._amplitudesView = d2CAmplitudesView;
        this._harmonicsView = d2CComponentsView;
        this._sumView = d2CSumView;
        this._spacingTool = wavePacketSpacingTool;
        this._periodTool = wavePacketPeriodTool;
        int n = FourierResources.getInt("D2CControlPanel.width", 275);
        this.setMinimumWidth(n);
        FourierTitledPanel fourierTitledPanel = new FourierTitledPanel(FourierResources.getString("D2CControlPanel.spacing"));
        this._spacingSlider = new WavePacketSpacingSlider();
        this._amplitudesEnvelopeCheckBox = new JCheckBox(FourierResources.getString("D2CControlPanel.kEnvelope"));
        JPanel jPanel = new JPanel();
        Serializable serializable = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).setMinimumWidth(0, 30);
        int n2 = 0;
        int n3 = 1;
        ((EasyGridBagLayout)serializable).addComponent(this._spacingSlider, n2++, n3);
        ((EasyGridBagLayout)serializable).addComponent(this._amplitudesEnvelopeCheckBox, n2++, n3);
        fourierTitledPanel.setLayout(new BorderLayout());
        fourierTitledPanel.add((Component)jPanel, "West");
        jPanel = new FourierTitledPanel(FourierResources.getString("D2CControlPanel.center"));
        this._centerSlider = new WavePacketCenterSlider();
        serializable = new JPanel();
        Serializable serializable2 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        ((EasyGridBagLayout)serializable2).setMinimumWidth(0, 30);
        n3 = 0;
        int n4 = 1;
        ((EasyGridBagLayout)serializable2).addComponent(this._centerSlider, n3++, n4);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)serializable, "West");
        serializable = new FourierTitledPanel(FourierResources.getString("D2CControlPanel.widthControls"));
        this._kWidthSlider = new WavePacketKWidthSlider();
        this._xWidthSlider = new WavePacketXWidthSlider();
        serializable2 = new JPanel();
        Object object = new EasyGridBagLayout((JPanel)serializable2);
        ((Container)serializable2).setLayout((LayoutManager)object);
        ((EasyGridBagLayout)object).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)object).setAnchor(17);
        ((EasyGridBagLayout)object).setMinimumWidth(0, 30);
        n4 = 0;
        int n5 = 1;
        ((EasyGridBagLayout)object).addComponent(this._kWidthSlider, n4++, n5);
        ((EasyGridBagLayout)object).addComponent(this._xWidthSlider, n4++, n5);
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add((Component)serializable2, "West");
        serializable2 = new FourierTitledPanel(FourierResources.getString("D2CControlPanel.graphControls"));
        object = FourierResources.getString("D2CControlPanel.domain");
        this._domainChoices = new ArrayList();
        this._domainChoices.add(new FourierComboBox.Choice(Domain.SPACE, FourierResources.getString("domain.space")));
        this._domainChoices.add(new FourierComboBox.Choice(Domain.TIME, FourierResources.getString("domain.time")));
        this._domainComboBox = new FourierComboBox((String)object, this._domainChoices);
        object = new JPanel();
        this._sinesRadioButton = new JRadioButton(FourierResources.getString("waveType.sines"));
        this._cosinesRadioButton = new JRadioButton(FourierResources.getString("waveType.cosines"));
        Serializable serializable3 = new ButtonGroup();
        ((ButtonGroup)serializable3).add(this._sinesRadioButton);
        ((ButtonGroup)serializable3).add(this._cosinesRadioButton);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        easyGridBagLayout.setInsets(DEFAULT_INSETS);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.addComponent(this._sinesRadioButton, 0, 0);
        easyGridBagLayout.addComponent(this._cosinesRadioButton, 0, 1);
        this._sumEnvelopeCheckBox = new JCheckBox(FourierResources.getString("D2CControlPanel.xEnvelope"));
        this._showWidthsCheckBox = new JCheckBox(FourierResources.getString("D2CControlPanel.showWidths"));
        serializable3 = new JPanel();
        easyGridBagLayout = new EasyGridBagLayout((JPanel)serializable3);
        ((Container)serializable3).setLayout(easyGridBagLayout);
        easyGridBagLayout.setInsets(DEFAULT_INSETS);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setMinimumWidth(0, 30);
        int n6 = 0;
        int n7 = 1;
        easyGridBagLayout.addComponent(this._domainComboBox, n6++, n7);
        easyGridBagLayout.addComponent((Component)object, n6++, n7);
        easyGridBagLayout.addComponent(this._sumEnvelopeCheckBox, n6++, n7);
        easyGridBagLayout.addComponent(this._showWidthsCheckBox, n6++, n7);
        ((Container)serializable2).setLayout(new BorderLayout());
        ((Container)serializable2).add((Component)serializable3, "West");
        this.addFullWidth(fourierTitledPanel);
        this.addVerticalSpace(0);
        this.addFullWidth(jPanel);
        this.addVerticalSpace(0);
        this.addFullWidth((Component)serializable);
        this.addVerticalSpace(0);
        this.addFullWidth((Component)serializable2);
        this.reset();
        this._listener = new EventListener();
        this._amplitudesEnvelopeCheckBox.addActionListener(this._listener);
        this._sumEnvelopeCheckBox.addActionListener(this._listener);
        this._showWidthsCheckBox.addActionListener(this._listener);
        this._sinesRadioButton.addActionListener(this._listener);
        this._cosinesRadioButton.addActionListener(this._listener);
        this._spacingSlider.addChangeListener(this._listener);
        this._centerSlider.addChangeListener(this._listener);
        this._kWidthSlider.addChangeListener(this._listener);
        this._xWidthSlider.addChangeListener(this._listener);
        this._domainComboBox.addItemListener(this._listener);
    }

    public void setSpacing(double d) {
        this._spacingSlider.setValue(d);
        this.handleSpacing();
    }

    public double getSpacing() {
        return this._spacingSlider.getValue();
    }

    public void setAmplitudesEnvelopeEnabled(boolean bl) {
        this._amplitudesEnvelopeCheckBox.setSelected(bl);
        this.handleAmplitudeEnvelope();
    }

    public boolean isAmplitudesEnvelopeEnabled() {
        return this._amplitudesEnvelopeCheckBox.isSelected();
    }

    public void setCenter(double d) {
        this._centerSlider.setValue(d);
        this.handleCenter();
    }

    public double getCenter() {
        return this._centerSlider.getValue();
    }

    public void setKWidth(double d) {
        this._kWidthSlider.setValue(d);
        this.handleKWidth();
    }

    public double getKWidth() {
        return this._kWidthSlider.getValue();
    }

    public void setDomain(Domain domain) {
        this._domainComboBox.setSelectedKey(domain);
        this.handleDomain();
    }

    public Domain getDomain() {
        return (Domain)this._domainComboBox.getSelectedKey();
    }

    public void setWaveType(WaveType waveType) {
        if (waveType == WaveType.SINES) {
            this._sinesRadioButton.setSelected(true);
        } else {
            this._cosinesRadioButton.setSelected(true);
        }
        this.handleWaveType();
    }

    public WaveType getWaveType() {
        WaveType waveType = null;
        waveType = this._sinesRadioButton.isSelected() ? WaveType.SINES : WaveType.COSINES;
        return waveType;
    }

    public void setSumEnvelopeEnabled(boolean bl) {
        this._sumEnvelopeCheckBox.setSelected(bl);
        this.handleSumEnvelope();
    }

    public boolean isSumEnvelopeEnabled() {
        return this._sumEnvelopeCheckBox.isSelected();
    }

    public void setShowWidthsEnabled(boolean bl) {
        this._showWidthsCheckBox.setSelected(bl);
        this.handleShowWidths();
    }

    public boolean isShowWidthsEnabled() {
        return this._showWidthsCheckBox.isSelected();
    }

    public void reset() {
        this._amplitudesEnvelopeCheckBox.setSelected(this._amplitudesView.isEnvelopeEnabled());
        this._sumEnvelopeCheckBox.setSelected(this._sumView.isEnvelopeEnabled());
        this._showWidthsCheckBox.setSelected(false);
        this._amplitudesView.setKWidthVisible(this._showWidthsCheckBox.isSelected());
        this._sumView.setXWidthVisible(this._showWidthsCheckBox.isSelected());
        this._domainComboBox.setSelectedKey(Domain.SPACE);
        this.handleDomain();
        this._sinesRadioButton.setSelected(true);
        this._spacingSlider.setValue(this._wavePacket.getK1());
        this._centerSlider.setValue(this._wavePacket.getK0());
        this._kWidthSlider.setValue(this._wavePacket.getDeltaK());
        this._xWidthSlider.setValue(this._wavePacket.getDeltaX());
    }

    private void handleDomain() {
        Domain domain = (Domain)this._domainComboBox.getSelectedKey();
        this._amplitudesView.setDomain(domain);
        this._harmonicsView.setDomain(domain);
        this._sumView.setDomain(domain);
        this._spacingTool.setDomain(domain);
        this._periodTool.setDomain(domain);
        if (domain == Domain.SPACE) {
            this._spacingSlider.setFormat(FourierResources.getString("WavePacketSpacingSlider.format.space"));
            this._centerSlider.setFormat(FourierResources.getString("WavePacketCenterSlider.format.space"));
            this._kWidthSlider.setFormat(FourierResources.getString("WavePacketKWidthSlider.format.space"));
            this._xWidthSlider.setFormat(FourierResources.getString("WavePacketXWidthSlider.format.space"));
            this._amplitudesEnvelopeCheckBox.setText(FourierResources.getString("D2CControlPanel.kEnvelope"));
            this._sumEnvelopeCheckBox.setText(FourierResources.getString("D2CControlPanel.xEnvelope"));
        } else if (domain == Domain.TIME) {
            this._spacingSlider.setFormat(FourierResources.getString("WavePacketSpacingSlider.format.time"));
            this._centerSlider.setFormat(FourierResources.getString("WavePacketCenterSlider.format.time"));
            this._kWidthSlider.setFormat(FourierResources.getString("WavePacketKWidthSlider.format.time"));
            this._xWidthSlider.setFormat(FourierResources.getString("WavePacketXWidthSlider.format.time"));
            this._amplitudesEnvelopeCheckBox.setText(FourierResources.getString("D2CControlPanel.wEnvelope"));
            this._sumEnvelopeCheckBox.setText(FourierResources.getString("D2CControlPanel.tEnvelope"));
        } else {
            throw new IllegalArgumentException("unsupported domain: " + domain);
        }
    }

    private void handleWaveType() {
        this.setWaitCursorEnabled(true);
        WaveType waveType = this._sinesRadioButton.isSelected() ? WaveType.SINES : WaveType.COSINES;
        this._harmonicsView.setWaveType(waveType);
        this._sumView.setWaveType(waveType);
        this.setWaitCursorEnabled(false);
    }

    private void handleAmplitudeEnvelope() {
        this.setWaitCursorEnabled(true);
        this._amplitudesView.setEnvelopeEnabled(this._amplitudesEnvelopeCheckBox.isSelected());
        this.setWaitCursorEnabled(false);
    }

    private void handleSumEnvelope() {
        this.setWaitCursorEnabled(true);
        this._sumView.setEnvelopeEnabled(this._sumEnvelopeCheckBox.isSelected());
        this.setWaitCursorEnabled(false);
    }

    private void handleSpacing() {
        if (!this._spacingSlider.isAdjusting()) {
            this.setWaitCursorEnabled(true);
            double d = this._spacingSlider.getValue();
            this._wavePacket.setK1(d);
            this.setWaitCursorEnabled(false);
        }
    }

    private void handleCenter() {
        if (!this._centerSlider.isAdjusting()) {
            this.setWaitCursorEnabled(true);
            double d = this._centerSlider.getValue();
            this._wavePacket.setK0(d);
            this.setWaitCursorEnabled(false);
        }
    }

    private void handleKWidth() {
        this.setWaitCursorEnabled(true);
        double d = this._kWidthSlider.getValue();
        this._xWidthSlider.removeChangeListener(this._listener);
        this._xWidthSlider.setValue(1.0 / d);
        this._xWidthSlider.addChangeListener(this._listener);
        if (!this._kWidthSlider.isAdjusting()) {
            this._wavePacket.setDeltaK(d);
        }
        this.setWaitCursorEnabled(false);
    }

    private void handleXWidth() {
        this.setWaitCursorEnabled(true);
        double d = this._xWidthSlider.getValue();
        this._kWidthSlider.removeChangeListener(this._listener);
        this._kWidthSlider.setValue(1.0 / d);
        this._kWidthSlider.addChangeListener(this._listener);
        if (!this._xWidthSlider.isAdjusting()) {
            this._wavePacket.setDeltaX(d);
        }
        this.setWaitCursorEnabled(false);
    }

    private void handleShowWidths() {
        this._amplitudesView.setKWidthVisible(this._showWidthsCheckBox.isSelected());
        this._sumView.setXWidthVisible(this._showWidthsCheckBox.isSelected());
    }

    private class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == D2CControlPanel.this._amplitudesEnvelopeCheckBox) {
                D2CControlPanel.this.handleAmplitudeEnvelope();
            } else if (actionEvent.getSource() == D2CControlPanel.this._sumEnvelopeCheckBox) {
                D2CControlPanel.this.handleSumEnvelope();
            } else if (actionEvent.getSource() == D2CControlPanel.this._showWidthsCheckBox) {
                D2CControlPanel.this.handleShowWidths();
            } else if (actionEvent.getSource() == D2CControlPanel.this._sinesRadioButton || actionEvent.getSource() == D2CControlPanel.this._cosinesRadioButton) {
                D2CControlPanel.this.handleWaveType();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == D2CControlPanel.this._spacingSlider) {
                D2CControlPanel.this.handleSpacing();
            } else if (changeEvent.getSource() == D2CControlPanel.this._centerSlider) {
                D2CControlPanel.this.handleCenter();
            } else if (changeEvent.getSource() == D2CControlPanel.this._kWidthSlider) {
                D2CControlPanel.this.handleKWidth();
            } else if (changeEvent.getSource() == D2CControlPanel.this._xWidthSlider) {
                D2CControlPanel.this.handleXWidth();
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == D2CControlPanel.this._domainComboBox.getComboBox()) {
                    D2CControlPanel.this.handleDomain();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }
    }
}

