/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.SinePlot;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.event.HarmonicColorChangeEvent;
import edu.colorado.phet.fourier.event.HarmonicColorChangeListener;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;

public class HarmonicPlot
extends SinePlot
implements SimpleObserver,
HarmonicColorChangeListener {
    private static final WaveType DEFAULT_WAVE_TYPE = WaveType.SINES;
    private Harmonic _harmonic;
    private WaveType _waveType;

    public HarmonicPlot(Component component, Chart chart) {
        super(component, chart);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._harmonic = null;
        this._waveType = WaveType.COSINES;
        this.setWaveType(WaveType.SINES);
        this.setShowZeroAmplitudeEnabled(false);
        HarmonicColors.getInstance().addHarmonicColorChangeListener(this);
    }

    public void cleanup() {
        super.cleanup();
        if (this._harmonic != null) {
            this._harmonic.removeObserver(this);
            this._harmonic = null;
        }
        HarmonicColors.getInstance().removeHarmonicColorChangeListener(this);
    }

    public void setHarmonic(Harmonic harmonic) {
        assert (harmonic != null);
        if (this._harmonic != null) {
            this._harmonic.removeObserver(this);
        }
        this._harmonic = harmonic;
        this._harmonic.addObserver(this);
        this.update();
    }

    public Harmonic getHarmonic() {
        return this._harmonic;
    }

    public void setWaveType(WaveType waveType) {
        if (waveType != this._waveType) {
            this._waveType = waveType;
            super.setCosineEnabled(this._waveType == WaveType.COSINES);
        }
    }

    public void update() {
        if (this.isVisible() && this._harmonic != null) {
            this.setAmplitude(this._harmonic.getAmplitude());
        }
    }

    public void harmonicColorChanged(HarmonicColorChangeEvent harmonicColorChangeEvent) {
        if (this._harmonic != null && this._harmonic.getOrder() == harmonicColorChangeEvent.getOrder()) {
            Color color = HarmonicColors.getInstance().getColor(this._harmonic);
            this.setBorderColor(color);
        }
    }
}

