/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.enums.WaveType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class GaussianWavePacketPlot
extends LinePlot {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private double _dx;
    private double _k0;
    private WaveType _waveType;
    private double _pixelsPerPoint;
    private Point2D[] _points;
    private double _maxAmplitude;

    public GaussianWavePacketPlot(Component component, Chart chart) {
        super(component, chart);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._dx = 1.0;
        this._k0 = 0.0;
        this._waveType = WaveType.SINES;
        this._pixelsPerPoint = 1.0;
        this._points = null;
        this._maxAmplitude = 0.0;
        this.setDataSet(new DataSet());
        this.setBorderColor(DEFAULT_COLOR);
        this.setStroke(DEFAULT_STROKE);
        this.updateDataSet();
    }

    public void setDeltaX(double d) {
        assert (d > 0.0);
        if (d != this._dx) {
            this._dx = d;
            this.updateDataSet();
        }
    }

    public void setK0(double d) {
        if (d != this._k0) {
            this._k0 = d;
            this.updateDataSet();
        }
    }

    public void setWaveType(WaveType waveType) {
        if (waveType != this._waveType) {
            this._waveType = waveType;
            this.updateDataSet();
        }
    }

    public WaveType getWaveType() {
        return this._waveType;
    }

    public void setPixelsPerPoint(double d) {
        assert (d > 0.0);
        if (d != this._pixelsPerPoint) {
            this._pixelsPerPoint = d;
            this.updateDataSet();
        }
    }

    public double getPixelsPerPoint() {
        return this._pixelsPerPoint;
    }

    public double getMaxAmplitude() {
        return this._maxAmplitude;
    }

    public void transformChanged() {
        this.updateDataSet();
        super.transformChanged();
    }

    protected void updateDataSet() {
        if (this.isVisible()) {
            Chart chart = this.getChart();
            Range2D range2D = chart.getRange();
            DataSet dataSet = this.getDataSet();
            dataSet.clear();
            this._maxAmplitude = 0.0;
            double d = this.modelToViewX(range2D.getMinX());
            double d2 = this.modelToViewX(range2D.getMaxX());
            double d3 = d2 - d + 1.0;
            int n = (int)(d3 / this._pixelsPerPoint);
            double d4 = Math.abs(range2D.getMaxX() - range2D.getMinX());
            double d5 = d4 / (double)n;
            if (this._points == null || n + 1 != this._points.length) {
                this._points = new Point2D.Double[n + 1];
            }
            for (int i = 0; i < this._points.length; ++i) {
                double d6 = range2D.getMinX() + (double)i * d5;
                double d7 = 0.0;
                d7 = this._waveType == WaveType.SINES ? Math.exp(-(d6 * d6) / (2.0 * (this._dx * this._dx))) * FourierConstants.TRIG_CACHE.sin(this._k0 * d6) : Math.exp(-(d6 * d6) / (2.0 * (this._dx * this._dx))) * FourierConstants.TRIG_CACHE.cos(this._k0 * d6);
                if (this._points[i] == null) {
                    this._points[i] = new Point2D.Double(d6, d7);
                } else {
                    this._points[i].setLocation(d6, d7);
                }
                if (!(Math.abs(d7) > this._maxAmplitude)) continue;
                this._maxAmplitude = Math.abs(d7);
            }
            dataSet.addAllPoints(this._points);
        }
    }

    private double modelToViewX(double d) {
        return this.getChart().transformXDouble(d);
    }
}

