/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class BarPlot
extends DataSetGraphic {
    private double _barWidth;
    private Color _fillColor;
    private Color _borderColor;
    private Stroke _stroke;
    private ArrayList _points;

    public BarPlot(Component component, Chart chart, double d) {
        this(component, chart, d, Color.BLACK, null, null);
    }

    public BarPlot(Component component, Chart chart, double d, Color color, Color color2, Stroke stroke) {
        super(component, chart, new DataSet());
        this._barWidth = d;
        this._fillColor = color;
        this._borderColor = color2;
        this._stroke = stroke;
        this._points = new ArrayList();
    }

    public void setFillColor(Color color) {
        this._fillColor = color;
        this.updateGraphics();
    }

    private void updateGraphics() {
        this.clear();
        Point2D point2D = this.getChart().transformDouble(0.0, 0.0);
        for (int i = 0; i < this._points.size(); ++i) {
            Point2D point2D2 = (Point2D)this._points.get(i);
            Point2D point2D3 = this.getChart().transformDouble(point2D2);
            double d = this.getChart().transformXDouble(this._barWidth);
            double d2 = point2D3.getX() - d / 2.0;
            double d3 = point2D3.getY();
            double d4 = d;
            double d5 = point2D.getY() - point2D3.getY();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
            PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(this.getComponent(), double_, this._fillColor, this._stroke, this._borderColor);
            this.addGraphic(phetShapeGraphic);
        }
    }

    public void transformChanged() {
        this.updateGraphics();
    }

    public void cleared() {
        this._points.clear();
        this.updateGraphics();
    }

    public void pointAdded(Point2D point2D) {
        this._points.add(point2D);
        this.updateGraphics();
    }

    public void pointsAdded(Point2D[] point2DArray) {
        for (int i = 0; i < point2DArray.length; ++i) {
            this._points.add(point2DArray[i]);
        }
        this.updateGraphics();
    }
}

