/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.game;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.FourierSumPlot;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.view.game.GameSumChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class GameSumView
extends GraphicLayerSet
implements SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 216);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 135);
    private static final Font INSTRUCTIONS_FONT = new PhetFont(0, 22);
    private static final Color INSTRUCTIONS_COLOR = Color.MAGENTA;
    private static final Point INSTRUCTIONS_LOCATION = new Point(85, 10);
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.2732395447351628, 0.5, 1.2732395447351628);
    private static final Dimension CHART_SIZE = new Dimension(540, 135);
    private static final Stroke USER_SUM_STROKE = new BasicStroke(1.0f);
    private static final Color USER_SUM_COLOR = Color.BLACK;
    private static final Stroke RANDOM_SUM_STROKE = new BasicStroke(3.0f);
    private static final Color RANDOM_SUM_COLOR = Color.MAGENTA;
    private FourierSeries _userFourierSeries;
    private FourierSeries _randomFourierSeries;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private GameSumChart _chartGraphic;
    private FourierSumPlot _userSumPlot;
    private FourierSumPlot _randomSumPlot;

    public GameSumView(Component component, FourierSeries fourierSeries, FourierSeries fourierSeries2) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._userFourierSeries = fourierSeries;
        this._userFourierSeries.addObserver(this);
        this._randomFourierSeries = fourierSeries2;
        this._randomFourierSeries.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, GameSumView.BACKGROUND_SIZE.width, GameSumView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this.addGraphic(this._backgroundGraphic, 1.0);
        this._backgroundGraphic.setLocation(0, 0);
        String string = FourierResources.getString("GameSumView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(TITLE_LOCATION);
        this.addGraphic(this._titleGraphic, 2.0);
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component);
        hTMLGraphic.setFont(INSTRUCTIONS_FONT);
        hTMLGraphic.setColor(INSTRUCTIONS_COLOR);
        hTMLGraphic.setHTML(FourierResources.getString("GameSumView.instructions"));
        hTMLGraphic.setLocation(INSTRUCTIONS_LOCATION);
        this.addGraphic(hTMLGraphic, 2.0);
        this._chartGraphic = new GameSumChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(this._chartGraphic, 3.0);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(60, 50);
        this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        this._randomSumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, this._randomFourierSeries);
        this._randomSumPlot.setPeriod(1.0);
        this._randomSumPlot.setPixelsPerPoint(1.0);
        this._randomSumPlot.setStroke(RANDOM_SUM_STROKE);
        this._randomSumPlot.setBorderColor(RANDOM_SUM_COLOR);
        this._chartGraphic.addDataSetGraphic(this._randomSumPlot);
        this._chartGraphic.autoscaleY(this._randomSumPlot.getMaxAmplitude() * 1.5);
        this._userSumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, this._userFourierSeries);
        this._userSumPlot.setPeriod(1.0);
        this._userSumPlot.setPixelsPerPoint(1.0);
        this._userSumPlot.setStroke(USER_SUM_STROKE);
        this._userSumPlot.setBorderColor(USER_SUM_COLOR);
        this._chartGraphic.addDataSetGraphic(this._userSumPlot);
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 4.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._chartGraphic.setIgnoreMouse(true);
        this._minimizeButton.setCursorHand();
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, GameSumView.BACKGROUND_SIZE.width, n));
            this._chartGraphic.setChartSize(GameSumView.CHART_SIZE.width, n - 75);
            this._titleGraphic.setLocation(GameSumView.TITLE_LOCATION.x, n / 2);
            this.setBoundsDirty();
        }
    }

    public void update() {
        if (this.isVisible()) {
            this._userSumPlot.updateDataSet();
            this._randomSumPlot.updateDataSet();
            this._chartGraphic.autoscaleY(this._randomSumPlot.getMaxAmplitude() * 1.5);
        }
    }
}

