/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.game;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.enums.GameLevel;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.view.game.GameAmplitudesView;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import javax.swing.event.MouseInputAdapter;

public class GameManager
extends MouseInputAdapter
implements SimpleObserver {
    private FourierSeries _userFourierSeries;
    private FourierSeries _randomFourierSeries;
    private GameAmplitudesView _amplitudesView;
    private GameLevel _gameLevel;
    private Preset _preset;
    private Hashtable gameConfigs;
    private Random _random;
    private boolean _mouseIsPressed;
    private boolean _isAdjusting;

    public GameManager(FourierSeries fourierSeries, FourierSeries fourierSeries2, GameAmplitudesView gameAmplitudesView) {
        this._userFourierSeries = fourierSeries;
        this._userFourierSeries.addObserver(this);
        this._randomFourierSeries = fourierSeries2;
        this._amplitudesView = gameAmplitudesView;
        this._gameLevel = GameLevel.UNDEFINED;
        this._preset = Preset.UNDEFINED;
        this.gameConfigs = new Hashtable();
        this.gameConfigs.put(GameLevel.LEVEL1, new GameConfiguration(1, 1));
        this.gameConfigs.put(GameLevel.LEVEL2, new GameConfiguration(1, 2));
        this.gameConfigs.put(GameLevel.LEVEL3, new GameConfiguration(1, 11));
        this.gameConfigs.put(GameLevel.LEVEL4, new GameConfiguration(2, 2));
        this.gameConfigs.put(GameLevel.LEVEL5, new GameConfiguration(2, 11));
        this.gameConfigs.put(GameLevel.LEVEL6, new GameConfiguration(3, 3));
        this.gameConfigs.put(GameLevel.LEVEL7, new GameConfiguration(3, 11));
        this.gameConfigs.put(GameLevel.LEVEL8, new GameConfiguration(4, 4));
        this.gameConfigs.put(GameLevel.LEVEL9, new GameConfiguration(4, 11));
        this.gameConfigs.put(GameLevel.LEVEL10, new GameConfiguration(11, 11));
        this._random = new Random();
        this._isAdjusting = false;
    }

    public FourierSeries getRandomFourierSeries() {
        return this._randomFourierSeries;
    }

    public void setGameLevel(GameLevel gameLevel) {
        this._gameLevel = gameLevel;
        this.newGame();
    }

    public void setPreset(Preset preset) {
        this._preset = preset;
        this.newGame();
    }

    public void newGame() {
        this._isAdjusting = true;
        if (this._gameLevel == GameLevel.PRESET) {
            this._userFourierSeries.setNumberOfHarmonics(11);
            this._randomFourierSeries.setNumberOfHarmonics(11);
            for (int i = 0; i < this._userFourierSeries.getNumberOfHarmonics(); ++i) {
                this._userFourierSeries.getHarmonic(i).setAmplitude(0.0);
                this._randomFourierSeries.getHarmonic(i).setAmplitude(0.0);
            }
            this._randomFourierSeries.setPreset(Preset.CUSTOM);
            this._randomFourierSeries.setPreset(this._preset);
            this._amplitudesView.setSlidersVisible(true);
        } else {
            Integer n;
            int n2;
            GameConfiguration gameConfiguration = (GameConfiguration)this.gameConfigs.get(this._gameLevel);
            int n3 = 11;
            int n4 = gameConfiguration._numberOfNonZeroHarmonics;
            int n5 = gameConfiguration._numberOfSliders;
            this._userFourierSeries.setNumberOfHarmonics(n3);
            this._randomFourierSeries.setNumberOfHarmonics(n3);
            for (int i = 0; i < this._userFourierSeries.getNumberOfHarmonics(); ++i) {
                this._userFourierSeries.getHarmonic(i).setAmplitude(0.0);
                this._randomFourierSeries.getHarmonic(i).setAmplitude(0.0);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (arrayList.size() < n5) {
                Integer n6 = new Integer(this._random.nextInt(n3));
                if (arrayList.contains(n6)) continue;
                arrayList.add(n6);
            }
            for (n2 = 0; n2 < n4; ++n2) {
                n = (Integer)arrayList.get(n2);
                double d = this.generateRandomAmplitude();
                this._randomFourierSeries.getHarmonic(n).setAmplitude(d);
            }
            this._amplitudesView.setSlidersVisible(false);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                n = (Integer)arrayList.get(n2);
                this._amplitudesView.setSliderVisible(n, true);
            }
        }
        this._isAdjusting = false;
        this.update();
    }

    private double generateRandomAmplitude() {
        int n = this._random.nextBoolean() ? 1 : -1;
        double d = 0.1;
        double d2 = 0.01;
        int n2 = (int)((1.2732395447351628 - d) / d2) + 1;
        double d3 = (double)this._random.nextInt(n2) * d2;
        double d4 = (double)n * (d + d3);
        assert (d4 <= 1.2732395447351628);
        return d4;
    }

    public void update() {
        if (this._isAdjusting) {
            return;
        }
        if (this._gameLevel == GameLevel.UNDEFINED) {
            return;
        }
        if (this._mouseIsPressed) {
            return;
        }
        if (this.isMatch()) {
            this._userFourierSeries.removeObserver(this);
            this._userFourierSeries.notifyObservers();
            this._userFourierSeries.addObserver(this);
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            String string = FourierResources.getString("WinDialog.title");
            String string2 = FourierResources.getString("WinDialog.message");
            PhetOptionPane.showMessageDialog(phetFrame, string2, string, -1);
            this.newGame();
        }
    }

    private boolean isMatch() {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = this._userFourierSeries.getNumberOfHarmonics();
        for (int i = 0; i < n3 && bl; ++i) {
            double d = this._userFourierSeries.getHarmonic(i).getAmplitude();
            double d2 = this._randomFourierSeries.getHarmonic(i).getAmplitude();
            int n4 = 0;
            n4 = d < 0.0 ? (int)(100.0 * d - 0.005) : (int)(100.0 * d + 0.005);
            int n5 = 0;
            n5 = d2 < 0.0 ? (int)(100.0 * d2 - 0.005) : (int)(100.0 * d2 + 0.005);
            if (n5 != 0) {
                ++n2;
            }
            if (n5 < 0 && n4 > 0 || n5 > 0 && n4 < 0) {
                bl = false;
                continue;
            }
            if (n5 == 0) {
                if (Math.abs(n4) <= 3) continue;
                bl = false;
                continue;
            }
            int n6 = Math.abs(n4 - n5);
            if (n6 > 9) {
                bl = false;
                continue;
            }
            if (n6 > 3) continue;
            ++n;
        }
        if (bl && n < 2 && n != n2) {
            bl = false;
        }
        return bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._mouseIsPressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._mouseIsPressed = false;
        this.update();
    }

    private class GameConfiguration {
        private int _numberOfNonZeroHarmonics;
        private int _numberOfSliders;

        public GameConfiguration(int n, int n2) {
            if (n2 < n) {
                throw new IllegalArgumentException("numberOfSlider must be >= numberOfNonZeroHarmonics");
            }
            this._numberOfNonZeroHarmonics = n;
            this._numberOfSliders = n2;
        }
    }
}

