/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetZoomControl;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.FlattenedChart;
import edu.colorado.phet.fourier.charts.FourierSumPlot;
import edu.colorado.phet.fourier.charts.GaussianWavePacketPlot;
import edu.colorado.phet.fourier.charts.WavePacketXWidthPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.d2c.D2CSumChart;
import edu.colorado.phet.fourier.view.d2c.D2CSumEquation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class D2CSumView
extends GraphicLayerSet
implements SimpleObserver,
PhetZoomControl.ZoomListener {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 150);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 115);
    private static final Range2D CHART_RANGE = new Range2D(-2.0, -1.0, 2.0, 1.0);
    private static final Dimension CHART_SIZE = new Dimension(540, 100);
    private static final Stroke SUM_STROKE = new BasicStroke(1.0f);
    private static final Color SUM_COLOR = Color.BLACK;
    private static final Stroke WAVE_PACKET_STROKE = SUM_STROKE;
    private static final Color WAVE_PACKET_COLOR = SUM_COLOR;
    private static final Color ENVELOPE_COLOR = Color.LIGHT_GRAY;
    private static final Stroke ENVELOPE_STROKE = new BasicStroke(4.0f, 1, 1);
    private GaussianWavePacket _wavePacket;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private PhetZoomControl _horizontalZoomControl;
    private D2CSumChart _chartGraphic;
    private FlattenedChart _flattenedChart;
    private D2CSumEquation _mathGraphic;
    private Domain _domain;
    private WaveType _waveType;
    private int _xZoomLevel;
    private FourierSeries _fourierSeries;
    private FourierSumPlot _sumPlot;
    private GaussianWavePacketPlot _wavePacketPlot;
    private LinePlot _envelopeGraphic;
    private boolean _envelopeEnabled;
    private WavePacketXWidthPlot _xWidthPlot;

    public D2CSumView(Component component, GaussianWavePacket gaussianWavePacket) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._wavePacket = gaussianWavePacket;
        this._wavePacket.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, D2CSumView.BACKGROUND_SIZE.width, D2CSumView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this._backgroundGraphic.setLocation(0, 0);
        this.addGraphic(this._backgroundGraphic, 1.0);
        String string = FourierResources.getString("D2CSumView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(40, D2CSumView.BACKGROUND_SIZE.height / 2);
        this.addGraphic(this._titleGraphic, 2.0);
        this._chartGraphic = new D2CSumChart(component, CHART_RANGE, CHART_SIZE);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(0, 0);
        this._xWidthPlot = new WavePacketXWidthPlot(component, (Chart)this._chartGraphic, this._wavePacket);
        this._chartGraphic.addDataSetGraphic(this._xWidthPlot);
        int n = 25;
        int n2 = 25;
        this._flattenedChart = new FlattenedChart(component, this._chartGraphic, n, n2);
        this.addGraphic(this._flattenedChart, 3.0);
        this._flattenedChart.setRegistrationPoint(0, 0);
        this._flattenedChart.setLocation(60 - n, 50 - n2);
        this._fourierSeries = new FourierSeries(1, 440.0);
        this._fourierSeries.setPreset(Preset.CUSTOM);
        this._sumPlot = new FourierSumPlot(component, (Chart)this._chartGraphic, this._fourierSeries);
        this._sumPlot.setPixelsPerPoint(0.25);
        this._sumPlot.setStroke(SUM_STROKE);
        this._sumPlot.setStrokeColor(SUM_COLOR);
        this._wavePacketPlot = new GaussianWavePacketPlot(component, this._chartGraphic);
        this._wavePacketPlot.setPixelsPerPoint(0.25);
        this._wavePacketPlot.setStroke(WAVE_PACKET_STROKE);
        this._wavePacketPlot.setStrokeColor(WAVE_PACKET_COLOR);
        this._envelopeGraphic = new LinePlot(component, this._chartGraphic);
        this._envelopeGraphic.setBorderColor(ENVELOPE_COLOR);
        this._envelopeGraphic.setStroke(ENVELOPE_STROKE);
        this._envelopeGraphic.setDataSet(new DataSet());
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 4.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        this._horizontalZoomControl = new PhetZoomControl(component, 0);
        this.addGraphic(this._horizontalZoomControl, 4.0);
        this._horizontalZoomControl.setLocation(620, 50);
        this._mathGraphic = new D2CSumEquation(component);
        this.addGraphic(this._mathGraphic, 5.0);
        this._mathGraphic.centerRegistrationPoint();
        this._mathGraphic.setLocation(330, 30);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._chartGraphic.setIgnoreMouse(true);
        this._mathGraphic.setIgnoreMouse(true);
        this._horizontalZoomControl.addZoomListener(this);
        this._minimizeButton.setCursorHand();
        this.reset();
    }

    public void reset() {
        this._envelopeEnabled = false;
        this._envelopeGraphic.setVisible(this._envelopeEnabled);
        this.setDomain(Domain.SPACE);
        this._waveType = WaveType.SINES;
        this._xZoomLevel = 0;
        this._chartGraphic.setRange(CHART_RANGE);
        this.refreshChart();
        this.updateZoomButtons();
        this.update();
    }

    public PhetZoomControl getHorizontalZoomControl() {
        return this._horizontalZoomControl;
    }

    public Chart getChart() {
        return this._chartGraphic;
    }

    public void setDomain(Domain domain) {
        this._domain = domain;
        this._xWidthPlot.setDomain(domain);
        this.updateMath();
        this.updateAxisTitles();
    }

    public void setWaveType(WaveType waveType) {
        if (waveType != this._waveType) {
            this._waveType = waveType;
            this.update();
            this.updateMath();
        }
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, D2CSumView.BACKGROUND_SIZE.width, n));
            this._titleGraphic.setLocation(D2CSumView.TITLE_LOCATION.x, n / 2);
            this._chartGraphic.setChartSize(D2CSumView.CHART_SIZE.width, n - 75);
            this.refreshChart();
            this.setBoundsDirty();
        }
    }

    public void setEnvelopeEnabled(boolean bl) {
        this._envelopeEnabled = bl;
        if (bl) {
            this.updateEnvelope();
        }
        this._envelopeGraphic.setVisible(bl);
        this.refreshChart();
    }

    public boolean isEnvelopeEnabled() {
        return this._envelopeEnabled;
    }

    public void setXWidthVisible(boolean bl) {
        this._xWidthPlot.setVisible(bl);
        this.refreshChart();
    }

    public void zoomPerformed(PhetZoomControl.ZoomEvent zoomEvent) {
        int n = zoomEvent.getZoomType();
        if (n != 2 && n != 3) {
            throw new IllegalArgumentException("unexpected event: " + zoomEvent);
        }
        this.handleHorizontalZoom(n);
    }

    private void handleHorizontalZoom(int n) {
        this._xZoomLevel = n == 2 ? ++this._xZoomLevel : --this._xZoomLevel;
        double d = Math.pow(2.0, (double)Math.abs(this._xZoomLevel) / 2.0);
        Range2D range2D = this._chartGraphic.getRange();
        double d2 = this._xZoomLevel == 0 ? 2.0 : (this._xZoomLevel > 0 ? 2.0 / d : 2.0 * d);
        if (d2 > 3.0) {
            this._chartGraphic.getHorizontalTicks().setMinorTicksVisible(false);
            this._chartGraphic.getHorizontalTicks().setMajorTickSpacing(1.0);
            range2D.setMaxX(d2);
            range2D.setMinX(-d2);
            this._chartGraphic.setRange(range2D);
        } else {
            range2D.setMaxX(d2);
            range2D.setMinX(-d2);
            this._chartGraphic.setRange(range2D);
            this._chartGraphic.getHorizontalTicks().setMinorTicksVisible(true);
            this._chartGraphic.getHorizontalTicks().setMajorTickSpacing(0.5);
        }
        this.updateEnvelope();
        this.refreshChart();
        this.updateZoomButtons();
    }

    private void updateZoomButtons() {
        Range2D range2D = this._chartGraphic.getRange();
        if (range2D.getMaxX() >= 8.0) {
            this._horizontalZoomControl.setZoomOutEnabled(false);
            this._horizontalZoomControl.setZoomInEnabled(true);
        } else if (range2D.getMaxX() <= 0.5) {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(false);
        } else {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(true);
        }
    }

    public void update() {
        this.updateMath();
        this._chartGraphic.removeAllDataSetGraphics();
        this._envelopeGraphic.setVisible(this._envelopeEnabled);
        this._chartGraphic.addDataSetGraphic(this._envelopeGraphic);
        double d = this._wavePacket.getK1();
        if (d > 0.0) {
            this.addFourierSeriesPlot();
        } else {
            this.addContinuousPlot();
        }
        if (this._envelopeEnabled) {
            this.updateEnvelope();
        }
        this._xWidthPlot.update();
        this._chartGraphic.addDataSetGraphic(this._xWidthPlot);
        this.refreshChart();
    }

    private void addFourierSeriesPlot() {
        double d = this._wavePacket.getK1();
        assert (d > 0.0);
        double d2 = this._wavePacket.getDeltaK();
        double d3 = this._wavePacket.getK0();
        int n = this._wavePacket.getNumberOfComponents();
        this._fourierSeries.setNumberOfHarmonics(n);
        this._fourierSeries.setWaveType(this._waveType);
        for (int i = 0; i < n; ++i) {
            double d4 = (double)(i + 1) * d;
            double d5 = d * GaussianWavePacket.getAmplitude(d4, d3, d2);
            this._fourierSeries.getHarmonic(i).setAmplitude(d5);
        }
        this._sumPlot.setPeriod(Math.PI * 2 / d);
        this._sumPlot.updateDataSet();
        this._chartGraphic.addDataSetGraphic(this._sumPlot);
        this._chartGraphic.autoscaleY(this._sumPlot.getMaxAmplitude() * 1.25);
    }

    private void addContinuousPlot() {
        this._wavePacketPlot.setK0(this._wavePacket.getK0());
        this._wavePacketPlot.setDeltaX(this._wavePacket.getDeltaX());
        this._wavePacketPlot.setWaveType(this._waveType);
        this._chartGraphic.addDataSetGraphic(this._wavePacketPlot);
        this._chartGraphic.autoscaleY(this._wavePacketPlot.getMaxAmplitude() * 1.25);
    }

    private void updateEnvelope() {
        Point2D[] point2DArray;
        Point2D[] point2DArray2;
        ArrayList<Point2D.Double> arrayList;
        DataSet dataSet = this._envelopeGraphic.getDataSet();
        dataSet.clear();
        if (this._wavePacket.getK1() > 0.0) {
            arrayList = new FourierSeries();
            ((FourierSeries)((Object)arrayList)).setPreset(Preset.CUSTOM);
            ((FourierSeries)((Object)arrayList)).setNumberOfHarmonics(this._fourierSeries.getNumberOfHarmonics());
            ((FourierSeries)((Object)arrayList)).setFundamentalFrequency(this._fourierSeries.getFundamentalFrequency());
            for (int i = 0; i < ((FourierSeries)((Object)arrayList)).getNumberOfHarmonics(); ++i) {
                Harmonic harmonic = this._fourierSeries.getHarmonic(i);
                ((FourierSeries)((Object)arrayList)).getHarmonic(i).setAmplitude(harmonic.getAmplitude());
            }
            if (this._fourierSeries.getWaveType() == WaveType.SINES) {
                ((FourierSeries)((Object)arrayList)).setWaveType(WaveType.COSINES);
            } else {
                ((FourierSeries)((Object)arrayList)).setWaveType(WaveType.SINES);
            }
            FourierSumPlot fourierSumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, (FourierSeries)((Object)arrayList));
            fourierSumPlot.setPeriod(this._sumPlot.getPeriod());
            fourierSumPlot.setPixelsPerPoint(this._sumPlot.getPixelsPerPoint());
            fourierSumPlot.updateDataSet();
            point2DArray2 = this._sumPlot.getDataSet().getPoints();
            point2DArray = fourierSumPlot.getDataSet().getPoints();
        } else {
            arrayList = new GaussianWavePacketPlot(this.getComponent(), this._chartGraphic);
            ((GaussianWavePacketPlot)((Object)arrayList)).setPixelsPerPoint(this._wavePacketPlot.getPixelsPerPoint());
            ((GaussianWavePacketPlot)((Object)arrayList)).setK0(this._wavePacket.getK0());
            ((GaussianWavePacketPlot)((Object)arrayList)).setDeltaX(this._wavePacket.getDeltaX());
            if (this._wavePacketPlot.getWaveType() == WaveType.SINES) {
                ((GaussianWavePacketPlot)((Object)arrayList)).setWaveType(WaveType.COSINES);
            } else {
                ((GaussianWavePacketPlot)((Object)arrayList)).setWaveType(WaveType.SINES);
            }
            point2DArray2 = this._wavePacketPlot.getDataSet().getPoints();
            point2DArray = ((DataSetGraphic)((Object)arrayList)).getDataSet().getPoints();
        }
        assert (point2DArray2.length == point2DArray.length);
        arrayList = new ArrayList<Point2D.Double>();
        int n = Math.max(point2DArray2.length, point2DArray.length);
        for (int i = 0; i < n; ++i) {
            double d = point2DArray2[i].getX();
            double d2 = Math.sqrt(point2DArray2[i].getY() * point2DArray2[i].getY() + point2DArray[i].getY() * point2DArray[i].getY());
            arrayList.add(new Point2D.Double(d, d2));
        }
        dataSet.addPoints(arrayList.toArray(new Point2D.Double[arrayList.size()]));
    }

    private void updateMath() {
        boolean bl = this._wavePacket.getK1() == 0.0;
        this._mathGraphic.setForm(this._domain, bl, this._waveType);
        this._mathGraphic.centerRegistrationPoint();
    }

    private void updateAxisTitles() {
        if (this._domain == Domain.SPACE) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        } else if (this._domain == Domain.TIME) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t.units"));
        }
        this.refreshChart();
    }

    private void refreshChart() {
        this._flattenedChart.flatten();
    }
}

