/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.event.HarmonicColorChangeEvent;
import edu.colorado.phet.fourier.event.HarmonicColorChangeListener;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class AmplitudeSlider
extends GraphicLayerSet
implements SimpleObserver,
HarmonicColorChangeListener {
    private static final Font VALUE_FONT = new PhetFont(0, 12);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(0, 12);
    private static final Color KNOB_FILL_COLOR = Color.BLACK;
    private static final Dimension DEFAULT_TRACK_SIZE = new Dimension(40, 100);
    private static final Color DEFAULT_TRACK_COLOR = Color.WHITE;
    private static final Stroke TRACK_STROKE = new BasicStroke(1.0f);
    private static final Color TRACK_BORDER_COLOR = Color.BLACK;
    private Harmonic _harmonic;
    private Dimension _maxSize;
    private HTMLGraphic _labelGraphic;
    private PhetGraphic _valueGraphic;
    private JTextField _valueTextField;
    private NumberFormat _valueFormatter;
    private PhetShapeGraphic _trackGraphic;
    private Rectangle _trackRectangle;
    private Color _trackColor;
    private PhetShapeGraphic _knobGraphic;
    private Rectangle _knobRectangle;
    private PhetShapeGraphic _clickZoneGraphic;
    private Rectangle _clickZoneRectangle;
    private EventListenerList _listenerList;
    private Point _somePoint;

    public AmplitudeSlider(Component component, Harmonic harmonic) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        assert (harmonic != null);
        this._harmonic = harmonic;
        this._harmonic.addObserver(this);
        this._maxSize = new Dimension(DEFAULT_TRACK_SIZE);
        this._listenerList = new EventListenerList();
        this._somePoint = new Point();
        char c = MathStrings.C_AMPLITUDE;
        String string = String.valueOf(this._harmonic.getOrder() + 1);
        String string2 = "<html>" + c + "<sub>" + string + "</sub></html>";
        this._labelGraphic = new HTMLGraphic(component, LABEL_FONT, string2, LABEL_COLOR);
        this._labelGraphic.centerRegistrationPoint();
        this._labelGraphic.setLocation(0, 0);
        this._valueFormatter = new DecimalFormat("0.00");
        this._valueTextField = new JTextField("--0.00");
        this._valueTextField.setPreferredSize(this._valueTextField.getPreferredSize());
        this._valueTextField.setFont(VALUE_FONT);
        this._valueTextField.setHorizontalAlignment(4);
        this._valueGraphic = PhetJComponent.newInstance(component, this._valueTextField);
        this._valueGraphic.setName("AmplitudeSlider.value");
        this._valueGraphic.centerRegistrationPoint();
        this._valueGraphic.setLocation(0, 0);
        this._clickZoneGraphic = new PhetShapeGraphic(component);
        this._clickZoneRectangle = new Rectangle(1, 1, this._maxSize.width, this._maxSize.height);
        this._clickZoneGraphic.setShape(this._clickZoneRectangle);
        this._clickZoneGraphic.setName("AmplitudeSlider.clickZone");
        this._clickZoneGraphic.setPaint(new Color(0, 0, 0, 0));
        this._clickZoneGraphic.centerRegistrationPoint();
        this._clickZoneGraphic.setLocation(0, 0);
        this._trackRectangle = new Rectangle();
        this._trackColor = DEFAULT_TRACK_COLOR;
        this._trackGraphic = new PhetShapeGraphic(component);
        this._trackGraphic.setName("AmplitudeSlider.track");
        this._trackGraphic.setShape(this._trackRectangle);
        this._trackGraphic.setPaint(this._trackColor);
        this._trackGraphic.setBorderColor(TRACK_BORDER_COLOR);
        this._trackGraphic.setStroke(TRACK_STROKE);
        this._trackGraphic.setLocation(0, 0);
        this._knobRectangle = new Rectangle(1, 0, this._maxSize.width + 1, 4);
        this._knobGraphic = new PhetShapeGraphic(component);
        this._knobGraphic.setName("AmplitudeSlider.knob");
        this._knobGraphic.setShape(this._knobRectangle);
        this._knobGraphic.setPaint(KNOB_FILL_COLOR);
        this._knobGraphic.centerRegistrationPoint();
        this._knobGraphic.setLocation(0, 0);
        this._labelGraphic.setIgnoreMouse(true);
        TextFieldEventListener textFieldEventListener = new TextFieldEventListener();
        this._valueTextField.addActionListener(textFieldEventListener);
        this._valueTextField.addFocusListener(textFieldEventListener);
        this._valueTextField.addKeyListener(textFieldEventListener);
        this._clickZoneGraphic.setCursorHand();
        this._clickZoneGraphic.addMouseInputListener(new ClickZoneEventListener());
        this._knobGraphic.setCursorHand();
        this._knobGraphic.addMouseInputListener(new KnobEventListener());
        this._trackGraphic.setCursorHand();
        this._trackGraphic.addMouseInputListener(new TrackEventListener());
        this.addGraphic(this._labelGraphic, 5.0);
        this.addGraphic(this._valueGraphic, 4.0);
        this.addGraphic(this._clickZoneGraphic, 1.0);
        this.addGraphic(this._trackGraphic, 2.0);
        this.addGraphic(this._knobGraphic, 3.0);
        HarmonicColors.getInstance().addHarmonicColorChangeListener(this);
        this.update();
    }

    public void setHarmonic(Harmonic harmonic) {
        assert (harmonic != null);
        if (this._harmonic != null) {
            this._harmonic.removeObserver(this);
        }
        this._harmonic = harmonic;
        this._harmonic.addObserver(this);
        this.update();
    }

    public void setMaxSize(int n, int n2) {
        this._maxSize.setSize(n, n2);
        this._clickZoneRectangle.setRect(0.0, 0.0, this._maxSize.width, this._maxSize.height);
        this._clickZoneGraphic.setShapeDirty();
        this._clickZoneGraphic.centerRegistrationPoint();
        this._knobRectangle.setRect(1.0, 0.0, this._maxSize.width + 1, 4.0);
        this._knobGraphic.setShapeDirty();
        this._knobGraphic.centerRegistrationPoint();
        this.update();
    }

    private boolean processUserInput() {
        Serializable serializable;
        boolean bl = true;
        String string = this._valueTextField.getText();
        double d = 0.0;
        try {
            serializable = new Double(string);
            d = serializable;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.showUserInputErrorDialog();
            this.update();
        }
        if (Math.abs(d) > 1.2732395447351628) {
            bl = false;
            this.showUserInputErrorDialog();
            this.update();
        } else if (d != this._harmonic.getAmplitude()) {
            serializable = HarmonicColors.getInstance().getColor(this._harmonic);
            this.updateSlider(d, (Color)serializable);
            this._harmonic.setAmplitude(d);
            this.fireChangeEvent();
        }
        return bl;
    }

    private void showUserInputErrorDialog() {
        String string = FourierResources.getString("AmplitudeErrorDialog.message");
        JOptionPane jOptionPane = new JOptionPane(string, 0, -1);
        jOptionPane.createDialog(this.getComponent(), null).setVisible(true);
    }

    public void addHarmonicFocusListener(HarmonicFocusListener harmonicFocusListener) {
        this._listenerList.add(HarmonicFocusListener.class, harmonicFocusListener);
    }

    private void fireHarmonicFocusEvent(boolean bl) {
        if (this._harmonic.getAmplitude() != 0.0) {
            HarmonicFocusEvent harmonicFocusEvent = new HarmonicFocusEvent(this, this._harmonic, bl);
            Object[] objectArray = this._listenerList.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != HarmonicFocusListener.class) continue;
                HarmonicFocusListener harmonicFocusListener = (HarmonicFocusListener)objectArray[i + 1];
                if (bl) {
                    harmonicFocusListener.focusGained(harmonicFocusEvent);
                    continue;
                }
                harmonicFocusListener.focusLost(harmonicFocusEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    public void harmonicColorChanged(HarmonicColorChangeEvent harmonicColorChangeEvent) {
        if (harmonicColorChangeEvent.getOrder() == this._harmonic.getOrder()) {
            this.update();
        }
    }

    public void update() {
        double d = this._harmonic.getAmplitude();
        if (d == 0.0) {
            d = 0.0;
        }
        Color color = HarmonicColors.getInstance().getColor(this._harmonic);
        this.updateSlider(d, color);
    }

    private void updateSlider(double d, Color color) {
        this._labelGraphic.setLocation(0, -(this._maxSize.height / 2 + 35));
        int n = 0;
        n = d < 0.0 ? (int)(100.0 * d - 0.005) : (int)(100.0 * d + 0.005);
        double d2 = (double)n * 0.01;
        this._valueTextField.setText(this._valueFormatter.format(d2));
        this._valueGraphic.setLocation(0, -(this._maxSize.height / 2 + 17));
        int n2 = this._maxSize.width;
        int n3 = (int)Math.abs((double)(this._maxSize.height / 2) * (d / 1.2732395447351628));
        int n4 = -(n2 / 2);
        int n5 = d > 0.0 ? -n3 : 0;
        this._trackRectangle.setBounds(n4, n5, n2, n3);
        this._trackGraphic.setShapeDirty();
        this._trackGraphic.setPaint(color);
        int n6 = this._knobGraphic.getX();
        int n7 = (int)(-((double)(this._maxSize.height / 2) * (d / 1.2732395447351628)));
        this._knobGraphic.setLocation(n6, n7);
        this.repaint();
    }

    private void setAmplitude(Point point) {
        double d = 0.0;
        try {
            AffineTransform affineTransform = this.getNetTransform();
            affineTransform.inverseTransform(point, this._somePoint);
            d = this._somePoint.getY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        d = -d;
        double d2 = 1.2732395447351628 * (d / ((double)this._maxSize.height / 2.0));
        d2 = MathUtil.clamp(-1.2732395447351628, d2, 1.2732395447351628);
        this._harmonic.setAmplitude(d2);
        this.fireChangeEvent();
    }

    private class ClickZoneEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
            AmplitudeSlider.this.fireHarmonicFocusEvent(true);
        }
    }

    private class KnobEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AmplitudeSlider.this.fireHarmonicFocusEvent(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AmplitudeSlider.this.fireHarmonicFocusEvent(false);
        }
    }

    private class TextFieldEventListener
    extends GraphicLayerSet.KeyAdapter
    implements ActionListener,
    FocusListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AmplitudeSlider.this._valueTextField) {
                AmplitudeSlider.this.processUserInput();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            AmplitudeSlider.this._valueTextField.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
            boolean bl;
            if (!focusEvent.isTemporary() && !(bl = AmplitudeSlider.this.processUserInput())) {
                AmplitudeSlider.this._valueTextField.requestFocus();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            double d;
            if (keyEvent.getKeyCode() == 38) {
                double d2 = AmplitudeSlider.this._harmonic.getAmplitude() + 0.01;
                if (d2 <= 1.2732395447351628) {
                    AmplitudeSlider.this._harmonic.setAmplitude(d2);
                    AmplitudeSlider.this.fireChangeEvent();
                }
            } else if (keyEvent.getKeyCode() == 40 && (d = AmplitudeSlider.this._harmonic.getAmplitude() - 0.01) >= -1.2732395447351628) {
                AmplitudeSlider.this._harmonic.setAmplitude(d);
                AmplitudeSlider.this.fireChangeEvent();
            }
        }
    }

    private class TrackEventListener
    extends MouseInputAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AmplitudeSlider.this.setAmplitude(mouseEvent.getPoint());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AmplitudeSlider.this.fireHarmonicFocusEvent(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AmplitudeSlider.this.fireHarmonicFocusEvent(false);
        }
    }
}

