/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.GameControlPanel;
import edu.colorado.phet.fourier.enums.GameLevel;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.help.HelpBubble;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.persistence.FourierConfig;
import edu.colorado.phet.fourier.view.MinimizedView;
import edu.colorado.phet.fourier.view.game.GameAmplitudesView;
import edu.colorado.phet.fourier.view.game.GameHarmonicsView;
import edu.colorado.phet.fourier.view.game.GameManager;
import edu.colorado.phet.fourier.view.game.GameSumView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class GameModule
extends FourierAbstractModule
implements ApparatusPanel2.ChangeListener {
    private static final Color APPARATUS_BACKGROUND = Color.WHITE;
    private FourierSeries _userFourierSeries;
    private FourierSeries _randomFourierSeries;
    private GameAmplitudesView _amplitudesView;
    private GameHarmonicsView _harmonicsView;
    private MinimizedView _harmonicsMinimizedView;
    private GameSumView _sumView;
    private MinimizedView _sumMinimizedView;
    private GameControlPanel _controlPanel;
    private Dimension _canvasSize;
    private GameManager _gameManager;

    public GameModule() {
        super(FourierResources.getString("GameModule.title"));
        this.getModulePanel().addComponentListener(new ModuleVisibleListener());
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._userFourierSeries = new FourierSeries(11, 440.0);
        this._userFourierSeries.setPreset(Preset.CUSTOM);
        this._userFourierSeries.setWaveType(WaveType.SINES);
        for (int i = 0; i < this._userFourierSeries.getNumberOfHarmonics(); ++i) {
            this._userFourierSeries.getHarmonic(i).setAmplitude(0.0);
        }
        this._randomFourierSeries = new FourierSeries(11, 440.0);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 710, 630);
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        apparatusPanel3.addChangeListener(this);
        this._canvasSize = apparatusPanel3.getSize();
        this._amplitudesView = new GameAmplitudesView(apparatusPanel3, this._userFourierSeries, this._randomFourierSeries);
        this._amplitudesView.setLocation(0, 0);
        apparatusPanel3.addGraphic(this._amplitudesView, 1.0);
        this._harmonicsView = new GameHarmonicsView(apparatusPanel3, this._userFourierSeries);
        apparatusPanel3.addGraphic(this._harmonicsView, 2.0);
        this._harmonicsMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("GameHarmonicsView.title"));
        apparatusPanel3.addGraphic(this._harmonicsMinimizedView, 4.0);
        this._sumView = new GameSumView(apparatusPanel3, this._userFourierSeries, this._randomFourierSeries);
        apparatusPanel3.addGraphic(this._sumView, 3.0);
        this._sumMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("GameSumView.title"));
        apparatusPanel3.addGraphic(this._sumMinimizedView, 5.0);
        this.setClockControlPanelEmpty(true);
        this._gameManager = new GameManager(this._userFourierSeries, this._randomFourierSeries, this._amplitudesView);
        apparatusPanel3.addMouseListener(this._gameManager);
        this._controlPanel = new GameControlPanel(this, this._gameManager);
        this.setControlPanel(this._controlPanel);
        this._amplitudesView.addHarmonicFocusListener(this._harmonicsView);
        this._harmonicsView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GameModule.this._harmonicsView.setVisible(false);
                GameModule.this._harmonicsMinimizedView.setVisible(true);
                GameModule.this.layoutViews();
            }
        });
        this._harmonicsMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GameModule.this._harmonicsView.setVisible(true);
                GameModule.this._harmonicsMinimizedView.setVisible(false);
                GameModule.this.setWaitCursorEnabled(true);
                GameModule.this.layoutViews();
                GameModule.this.setWaitCursorEnabled(false);
            }
        });
        this._sumView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GameModule.this._sumView.setVisible(false);
                GameModule.this._sumMinimizedView.setVisible(true);
                GameModule.this.layoutViews();
            }
        });
        this._sumMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                GameModule.this._sumView.setVisible(true);
                GameModule.this._sumMinimizedView.setVisible(false);
                GameModule.this.setWaitCursorEnabled(true);
                GameModule.this.layoutViews();
                GameModule.this.setWaitCursorEnabled(false);
            }
        });
        HelpBubble helpBubble = new HelpBubble(apparatusPanel3, FourierResources.getString("GameModule.help.sliders"));
        helpBubble.pointAt(new Point(252, 117), 1, 30);
        this.addHelpItem(helpBubble);
        HelpBubble helpBubble2 = new HelpBubble(apparatusPanel3, FourierResources.getString("GameModule.help.textfields"));
        helpBubble2.pointAt(new Point(205, 44), 1, 15);
        this.addHelpItem(helpBubble2);
        this.reset();
    }

    public void reset() {
        this._harmonicsView.setVisible(true);
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumView.setVisible(true);
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        this.layoutViews();
        this._controlPanel.reset();
    }

    private void layoutViews() {
        int n = this._canvasSize.height;
        int n2 = n - this._amplitudesView.getHeight();
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        if (this._harmonicsView.isVisible() && this._sumView.isVisible()) {
            this._harmonicsView.setHeight(n2 / 2);
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 / 2);
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._harmonicsView.isVisible()) {
            this._harmonicsView.setHeight(n2 - this._sumMinimizedView.getHeight());
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._sumView.isVisible()) {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 - this._harmonicsMinimizedView.getHeight());
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        } else {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        }
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._canvasSize.setSize(changeEvent.getCanvasSize());
        this.layoutViews();
    }

    public FourierConfig.GameConfig save() {
        FourierConfig.GameConfig gameConfig = new FourierConfig.GameConfig();
        gameConfig.setGameLevelName(this._controlPanel.getGameLevel().getName());
        gameConfig.setPresetName(this._controlPanel.getPreset().getName());
        gameConfig.setHarmonicsViewMaximized(this._harmonicsView.isVisible());
        gameConfig.setSumViewMaximized(this._sumView.isVisible());
        return gameConfig;
    }

    public void load(FourierConfig.GameConfig gameConfig) {
        this._controlPanel.setGameLevel(GameLevel.getByName(gameConfig.getGameLevelName()));
        this._controlPanel.setPreset(Preset.getByName(gameConfig.getPresetName()));
        this._harmonicsView.setVisible(gameConfig.isHarmonicsViewMaximized());
        this._sumView.setVisible(gameConfig.isSumViewMaximized());
        this.layoutViews();
    }

    private static class ModuleVisibleListener
    extends ComponentAdapter {
        boolean _instructionsHaveBeenDisplayed = false;

        private ModuleVisibleListener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (!this._instructionsHaveBeenDisplayed) {
                this._instructionsHaveBeenDisplayed = true;
                String string = FourierResources.getString("GameInstructionsDialog.message");
                String string2 = FourierResources.getString("GameInstructionsDialog.title");
                PhetOptionPane.showMessageDialog(PhetApplication.getInstance().getPhetFrame(), string, string2, -1);
            }
        }
    }
}

