/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.module;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.D2CControlPanel;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.help.HelpBubble;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.module.FourierAbstractModule;
import edu.colorado.phet.fourier.persistence.FourierConfig;
import edu.colorado.phet.fourier.view.MinimizedView;
import edu.colorado.phet.fourier.view.d2c.D2CAmplitudesView;
import edu.colorado.phet.fourier.view.d2c.D2CComponentsView;
import edu.colorado.phet.fourier.view.d2c.D2CSumView;
import edu.colorado.phet.fourier.view.tools.WavePacketPeriodTool;
import edu.colorado.phet.fourier.view.tools.WavePacketSpacingTool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class D2CModule
extends FourierAbstractModule
implements ApparatusPanel2.ChangeListener {
    private static final Color APPARATUS_BACKGROUND = new Color(240, 255, 255);
    private static final Point SPACING_TOOL_LOCATION = new Point(590, 140);
    private static final Point PERIOD_TOOL_LOCATION = new Point(440, 580);
    private GaussianWavePacket _wavePacket;
    private D2CAmplitudesView _amplitudesView;
    private D2CComponentsView _harmonicsView;
    private D2CSumView _sumView;
    private MinimizedView _harmonicsMinimizedView;
    private MinimizedView _sumMinimizedView;
    private D2CControlPanel _controlPanel;
    private Dimension _canvasSize;
    private WavePacketSpacingTool _spacingTool;
    private WavePacketPeriodTool _periodTool;

    public D2CModule() {
        super(FourierResources.getString("D2CModule.title"));
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._wavePacket = new GaussianWavePacket(Math.PI, Math.PI * 6, 37.69911184307752, 75.39822368615503);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 727, 630);
        this._canvasSize = apparatusPanel3.getSize();
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        apparatusPanel3.addChangeListener(this);
        this._amplitudesView = new D2CAmplitudesView(apparatusPanel3, this._wavePacket);
        this._amplitudesView.setLocation(0, 0);
        apparatusPanel3.addGraphic(this._amplitudesView, 1.0);
        this._harmonicsView = new D2CComponentsView(apparatusPanel3, this._wavePacket);
        apparatusPanel3.addGraphic(this._harmonicsView, 2.0);
        this._harmonicsMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("D2CHarmonicsView.title"));
        apparatusPanel3.addGraphic(this._harmonicsMinimizedView, 4.0);
        this._sumView = new D2CSumView(apparatusPanel3, this._wavePacket);
        apparatusPanel3.addGraphic(this._sumView, 3.0);
        this._sumMinimizedView = new MinimizedView(apparatusPanel3, FourierResources.getString("D2CSumView.title"));
        apparatusPanel3.addGraphic(this._sumMinimizedView, 5.0);
        this._spacingTool = new WavePacketSpacingTool(apparatusPanel3, this._wavePacket, this._amplitudesView.getChart());
        this._spacingTool.setDragBounds(this._amplitudesView.getChart().getBounds());
        apparatusPanel3.addGraphic(this._spacingTool, 6.0);
        int n = 0;
        int n2 = this._amplitudesView.getHeight();
        int n3 = 700;
        int n4 = 425;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        this._periodTool = new WavePacketPeriodTool(apparatusPanel3, this._wavePacket, this._sumView.getChart());
        this._periodTool.setDragBounds(rectangle);
        apparatusPanel3.addGraphic(this._periodTool, 6.0);
        this.setClockControlPanelEmpty(true);
        this._controlPanel = new D2CControlPanel(this, this._wavePacket, this._amplitudesView, this._harmonicsView, this._sumView, this._spacingTool, this._periodTool);
        this._controlPanel.addResetAllButton(this);
        this.setControlPanel(this._controlPanel);
        this._harmonicsView.getHorizontalZoomControl().addZoomListener(this._sumView);
        this._sumView.getHorizontalZoomControl().addZoomListener(this._harmonicsView);
        this._harmonicsView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                D2CModule.this._harmonicsView.setVisible(false);
                D2CModule.this._harmonicsMinimizedView.setVisible(true);
                D2CModule.this.layoutViews();
            }
        });
        this._harmonicsMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                D2CModule.this._harmonicsView.setVisible(true);
                D2CModule.this._harmonicsMinimizedView.setVisible(false);
                D2CModule.this.setWaitCursorEnabled(true);
                D2CModule.this.layoutViews();
                D2CModule.this.setWaitCursorEnabled(false);
            }
        });
        this._sumView.getMinimizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                D2CModule.this._sumView.setVisible(false);
                D2CModule.this._sumMinimizedView.setVisible(true);
                D2CModule.this.layoutViews();
            }
        });
        this._sumMinimizedView.getMaximizeButton().addMouseInputListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                D2CModule.this._sumView.setVisible(true);
                D2CModule.this._sumMinimizedView.setVisible(false);
                D2CModule.this.setWaitCursorEnabled(true);
                D2CModule.this.layoutViews();
                D2CModule.this.setWaitCursorEnabled(false);
            }
        });
        HelpBubble helpBubble = new HelpBubble(apparatusPanel3, FourierResources.getString("D2CModule.help.spacingTool"));
        helpBubble.pointAt(this._spacingTool, 4, 15);
        this.addHelpItem(helpBubble);
        HelpBubble helpBubble2 = new HelpBubble(apparatusPanel3, FourierResources.getString("D2CModule.help.periodTool"));
        helpBubble2.pointAt(this._periodTool, 4, 15);
        this.addHelpItem(helpBubble2);
        this.reset();
    }

    public void reset() {
        this._wavePacket.setSpacing(Math.PI);
        this._wavePacket.setWidth(Math.PI * 6);
        this._wavePacket.setCenter(37.69911184307752);
        this._wavePacket.setSignificantWidth(75.39822368615503);
        this._harmonicsView.setVisible(true);
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumView.setVisible(true);
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        this.layoutViews();
        this._amplitudesView.reset();
        this._harmonicsView.reset();
        this._sumView.reset();
        this._spacingTool.setLocation(SPACING_TOOL_LOCATION);
        this._periodTool.setLocation(PERIOD_TOOL_LOCATION);
        this._controlPanel.reset();
    }

    private void layoutViews() {
        int n = this._canvasSize.height;
        int n2 = n - this._amplitudesView.getHeight();
        this._harmonicsMinimizedView.setVisible(!this._harmonicsView.isVisible());
        this._sumMinimizedView.setVisible(!this._sumView.isVisible());
        if (this._harmonicsView.isVisible() && this._sumView.isVisible()) {
            this._harmonicsView.setHeight(n2 / 2);
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 / 2);
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._harmonicsView.isVisible()) {
            this._harmonicsView.setHeight(n2 - this._sumMinimizedView.getHeight());
            this._harmonicsView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsView.getY() + this._harmonicsView.getHeight());
        } else if (this._sumView.isVisible()) {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumView.setHeight(n2 - this._harmonicsMinimizedView.getHeight());
            this._sumView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        } else {
            this._harmonicsMinimizedView.setLocation(this._amplitudesView.getX(), this._amplitudesView.getY() + this._amplitudesView.getHeight());
            this._sumMinimizedView.setLocation(this._amplitudesView.getX(), this._harmonicsMinimizedView.getY() + this._harmonicsMinimizedView.getHeight());
        }
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._canvasSize.setSize(changeEvent.getCanvasSize());
        this.layoutViews();
    }

    public FourierConfig.D2CConfig save() {
        FourierConfig.D2CConfig d2CConfig = new FourierConfig.D2CConfig();
        d2CConfig.setSpacing(this._controlPanel.getSpacing());
        d2CConfig.setAmplitudesEnvelopeEnabled(this._controlPanel.isAmplitudesEnvelopeEnabled());
        d2CConfig.setCenter(this._controlPanel.getCenter());
        d2CConfig.setKWidth(this._controlPanel.getKWidth());
        d2CConfig.setDomainName(this._controlPanel.getDomain().getName());
        d2CConfig.setWaveTypeName(this._controlPanel.getWaveType().getName());
        d2CConfig.setSumEnvelopeEnabled(this._controlPanel.isSumEnvelopeEnabled());
        d2CConfig.setShowWidthsEnabled(this._controlPanel.isShowWidthsEnabled());
        d2CConfig.setHarmonicsViewMaximized(this._harmonicsView.isVisible());
        d2CConfig.setSumViewMaximized(this._sumView.isVisible());
        return d2CConfig;
    }

    public void load(FourierConfig.D2CConfig d2CConfig) {
        this._controlPanel.setSpacing(d2CConfig.getSpacing());
        this._controlPanel.setAmplitudesEnvelopeEnabled(d2CConfig.isAmplitudesEnvelopeEnabled());
        this._controlPanel.setCenter(d2CConfig.getCenter());
        this._controlPanel.setKWidth(d2CConfig.getKWidth());
        this._controlPanel.setDomain(Domain.getByName(d2CConfig.getDomainName()));
        this._controlPanel.setWaveType(WaveType.getByName(d2CConfig.getWaveTypeName()));
        this._controlPanel.setSumEnvelopeEnabled(d2CConfig.isSumEnvelopeEnabled());
        this._controlPanel.setShowWidthsEnabled(d2CConfig.isShowWidthsEnabled());
        this._harmonicsView.setVisible(d2CConfig.isHarmonicsViewMaximized());
        this._sumView.setVisible(d2CConfig.isSumViewMaximized());
        this.layoutViews();
    }
}

