/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.StringLabelTable;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.text.DecimalFormat;

public abstract class WaveformChart
extends Chart {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(2.0f);
    private static final Font AXIS_TITLE_FONT = new PhetFont(1, 16);
    private static final Color AXIS_TITLE_COLOR = Color.BLACK;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Font MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Color MAJOR_TICK_COLOR = Color.BLACK;
    private static final Color MAJOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MAJOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private static final Color MINOR_GRIDLINE_COLOR = Color.BLACK;
    private static final Stroke MINOR_GRIDLINE_STROKE = new BasicStroke(0.25f);
    private PhetTextGraphic _xAxisTitleGraphic;

    public WaveformChart(Component component, Range2D range2D, Dimension dimension, double d, double d2) {
        super(component, range2D, dimension);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.getXAxis().setStroke(AXIS_STROKE);
        this.getXAxis().setColor(AXIS_COLOR);
        this._xAxisTitleGraphic = new PhetTextGraphic(component, AXIS_TITLE_FONT, "", AXIS_TITLE_COLOR);
        this.setXAxisTitle(this._xAxisTitleGraphic);
        this.getXAxis().setMajorTicksVisible(false);
        this.getXAxis().setMajorTickLabelsVisible(false);
        this.getXAxis().setMinorTicksVisible(false);
        this.getXAxis().setMinorTickLabelsVisible(false);
        this.getHorizontalTicks().setMajorTicksVisible(true);
        this.getHorizontalTicks().setMajorTickLabelsVisible(true);
        this.getHorizontalTicks().setMajorTickSpacing(0.25);
        this.getHorizontalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getHorizontalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getHorizontalTicks().setMajorLabels(this.getActualSpaceLabels(0.5));
        this.getVerticalGridlines().setMajorGridlinesVisible(true);
        this.getVerticalGridlines().setMajorTickSpacing(0.25);
        this.getVerticalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getVerticalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getVerticalGridlines().setMinorGridlinesVisible(true);
        this.getVerticalGridlines().setMinorTickSpacing(0.125);
        this.getVerticalGridlines().setMinorGridlinesColor(MINOR_GRIDLINE_COLOR);
        this.getVerticalGridlines().setMinorGridlinesStroke(MINOR_GRIDLINE_STROKE);
        this.getYAxis().setStroke(AXIS_STROKE);
        this.getYAxis().setColor(AXIS_COLOR);
        this.getYAxis().setMajorTicksVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        this.getYAxis().setMinorTicksVisible(false);
        this.getYAxis().setMinorTickLabelsVisible(false);
        this.getVerticalTicks().setMajorTicksVisible(true);
        this.getVerticalTicks().setMajorTickLabelsVisible(true);
        this.getVerticalTicks().setMajorTickSpacing(d);
        this.getVerticalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getVerticalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getHorizonalGridlines().setMajorGridlinesVisible(true);
        this.getHorizonalGridlines().setMajorTickSpacing(d);
        this.getHorizonalGridlines().setMajorGridlinesColor(MAJOR_GRIDLINE_COLOR);
        this.getHorizonalGridlines().setMajorGridlinesStroke(MAJOR_GRIDLINE_STROKE);
        this.getHorizonalGridlines().setMinorGridlinesVisible(true);
        this.getHorizonalGridlines().setMinorTickSpacing(d2);
        this.getHorizonalGridlines().setMinorGridlinesColor(Color.BLACK);
        this.getHorizonalGridlines().setMinorGridlinesStroke(new BasicStroke(0.25f));
    }

    public void setXAxisTitle(String string) {
        this._xAxisTitleGraphic.setText(string);
        this._xAxisTitleGraphic.setRegistrationPoint(-4, -this._xAxisTitleGraphic.getHeight() / 2);
    }

    public StringLabelTable getActualSpaceLabels(double d) {
        double[] dArray = new double[]{-d, 0.0, d};
        return WaveformChart.createLabels(dArray, 1.0, 0.78, "#.##", this.getComponent());
    }

    public StringLabelTable getActualTimeLabels(double d) {
        double[] dArray = new double[]{-d, 0.0, d};
        return WaveformChart.createLabels(dArray, 1.0, 2.272727272727273, "#.##", this.getComponent());
    }

    private static StringLabelTable createLabels(double[] dArray, double d, double d2, String string, Component component) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        StringLabelTable stringLabelTable = new StringLabelTable(component, MAJOR_TICK_FONT, MAJOR_TICK_COLOR);
        for (int i = 0; i < dArray.length; ++i) {
            stringLabelTable.put(dArray[i] * d, decimalFormat.format(dArray[i] * d2));
        }
        return stringLabelTable;
    }

    public StringLabelTable getSymbolicSpaceLabels1() {
        StringLabelTable stringLabelTable = new StringLabelTable(this.getComponent(), MAJOR_TICK_FONT, MAJOR_TICK_COLOR);
        stringLabelTable.put(-1.0, "-L");
        stringLabelTable.put(-0.75, "-3L/4");
        stringLabelTable.put(-0.5, "-L/2");
        stringLabelTable.put(-0.25, "-L/4");
        stringLabelTable.put(0.0, "0");
        stringLabelTable.put(0.25, "L/4");
        stringLabelTable.put(0.5, "L/2");
        stringLabelTable.put(0.75, "3L/4");
        stringLabelTable.put(1.0, "L");
        return stringLabelTable;
    }

    public StringLabelTable getSymbolicSpaceLabels2() {
        StringLabelTable stringLabelTable = new StringLabelTable(this.getComponent(), MAJOR_TICK_FONT, MAJOR_TICK_COLOR);
        stringLabelTable.put(-2.0, "-2L");
        stringLabelTable.put(-1.5, "-3L/2");
        stringLabelTable.put(-1.0, "-L");
        stringLabelTable.put(-0.5, "-L/2");
        stringLabelTable.put(0.0, "0");
        stringLabelTable.put(0.5, "L/2");
        stringLabelTable.put(1.0, "L");
        stringLabelTable.put(1.5, "3L/2");
        stringLabelTable.put(2.0, "2L");
        return stringLabelTable;
    }

    public StringLabelTable getSymbolicTimeLabels1() {
        StringLabelTable stringLabelTable = new StringLabelTable(this.getComponent(), MAJOR_TICK_FONT, MAJOR_TICK_COLOR);
        stringLabelTable.put(-1.0, "-T");
        stringLabelTable.put(-0.75, "-3T/4");
        stringLabelTable.put(-0.5, "-T/2");
        stringLabelTable.put(-0.25, "-T/4");
        stringLabelTable.put(0.0, "0");
        stringLabelTable.put(0.25, "T/4");
        stringLabelTable.put(0.5, "T/2");
        stringLabelTable.put(0.75, "3T/4");
        stringLabelTable.put(1.0, "T");
        return stringLabelTable;
    }

    public StringLabelTable getSymbolicTimeLabels2() {
        StringLabelTable stringLabelTable = new StringLabelTable(this.getComponent(), MAJOR_TICK_FONT, MAJOR_TICK_COLOR);
        stringLabelTable.put(-2.0, "-2T");
        stringLabelTable.put(-1.5, "-3T/2");
        stringLabelTable.put(-1.0, "-T");
        stringLabelTable.put(-0.5, "-T/2");
        stringLabelTable.put(0.0, "0");
        stringLabelTable.put(0.5, "T/2");
        stringLabelTable.put(1.0, "T");
        stringLabelTable.put(1.5, "3T/2");
        stringLabelTable.put(2.0, "2T");
        return stringLabelTable;
    }
}

